/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RerunTestsAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public static final String ID = "RerunTests";
    private static final List<ExecutionEnvironment> REGISTRY = ContainerUtil.createLockFreeCopyOnWriteList();

    public static void register(final @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/RerunTestsAction", "register"));
        }
        REGISTRY.add(environment);
        Disposer.register((Disposable)environment, (Disposable)new Disposable(){

            public void dispose() {
                REGISTRY.remove(environment);
            }
        });
    }

    public void actionPerformed(AnActionEvent e) {
        for (ExecutionEnvironment environment : REGISTRY) {
            RunContentDescriptor descriptor;
            ProcessHandler processHandler;
            if (Disposer.isDisposed((Disposable)environment) || (processHandler = (descriptor = environment.getContentToReuse()) == null ? null : descriptor.getProcessHandler()) == null || !processHandler.isProcessTerminated()) continue;
            ExecutionUtil.restart((ExecutionEnvironment)environment);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(true);
    }
}

