/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.JreProvider;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;

public class AlternativeJREPanel
extends JPanel
implements PanelWithAnchor {
    private final ComponentWithBrowseButton<TextFieldWithHistory> myPathField;
    private final JBCheckBox myCbEnabled = new JBCheckBox(ExecutionBundle.message((String)"run.configuration.use.alternate.jre.checkbox", (Object[])new Object[0]));
    final TextFieldWithHistory myFieldWithHistory = new TextFieldWithHistory();
    private JComponent myAnchor;

    public AlternativeJREPanel() {
        Sdk[] allJDKs;
        this.myFieldWithHistory.setHistorySize(-1);
        ArrayList<String> foundJDKs = new ArrayList<String>();
        for (Sdk sdk : allJDKs = ProjectJdkTable.getInstance().getAllJdks()) {
            foundJDKs.add(sdk.getName());
        }
        for (JreProvider jreProvider : (JreProvider[])JreProvider.EP_NAME.getExtensions()) {
            String path = jreProvider.getJrePath();
            if (StringUtil.isEmpty((String)path)) continue;
            foundJDKs.add(path);
        }
        for (Sdk sdk : allJDKs) {
            File jre;
            String homePath = sdk.getHomePath();
            if (!SystemInfo.isMac && (jre = new File(sdk.getHomePath(), "jre")).isDirectory()) {
                homePath = jre.getPath();
            }
            if (foundJDKs.contains(homePath)) continue;
            foundJDKs.add(homePath);
        }
        this.myFieldWithHistory.setHistory(foundJDKs);
        this.myPathField = new ComponentWithBrowseButton((JComponent)this.myFieldWithHistory, null);
        this.myPathField.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 10, fill, flowx"));
        this.add((Component)this.myCbEnabled, "shrinkx");
        this.add((Component)this.myPathField, "growx, pushx");
        InsertPathAction.addTo((JTextComponent)this.myFieldWithHistory.getTextEditor());
        this.myCbEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlternativeJREPanel.this.enabledChanged();
            }
        });
        this.enabledChanged();
        this.setAnchor((JComponent)this.myCbEnabled);
        this.updateUI();
    }

    private void enabledChanged() {
        boolean pathEnabled = this.isPathEnabled();
        GuiUtils.enableChildren(this.myPathField, (boolean)pathEnabled, (JComponent[])new JComponent[0]);
        this.myFieldWithHistory.invalidate();
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)((TextFieldWithHistory)this.myPathField.getChildComponent()).getText().trim());
    }

    private void setPath(String path) {
        ((TextFieldWithHistory)this.myPathField.getChildComponent()).setText(FileUtil.toSystemDependentName((String)(path == null ? "" : path)));
    }

    public boolean isPathEnabled() {
        return this.myCbEnabled.isSelected();
    }

    private void setPathEnabled(boolean b) {
        this.myCbEnabled.setSelected(b);
        this.enabledChanged();
    }

    public void init(String path, boolean isEnabled) {
        this.setPathEnabled(isEnabled);
        this.setPath(path);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myCbEnabled.setAnchor(anchor);
    }

    public JBCheckBox getCbEnabled() {
        return this.myCbEnabled;
    }
}

