/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.java.LanguageLevel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectData
extends AbstractExternalEntityData {
    @NotNull
    public static final Key<JavaProjectData> KEY = Key.create(JavaProjectData.class, (int)(ProjectKeys.PROJECT.getProcessingWeight() + 1));
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaProjectData.class.getName()));
    private static final long serialVersionUID = 1L;
    private static final LanguageLevel DEFAULT_LANGUAGE_LEVEL = LanguageLevel.JDK_1_6;
    private static final JavaSdkVersion DEFAULT_JDK_VERSION = JavaSdkVersion.JDK_1_6;
    private static final Pattern JDK_VERSION_PATTERN = Pattern.compile(".*1.(\\d+).*");
    @NotNull
    private JavaSdkVersion myJdkVersion;
    @NotNull
    private LanguageLevel myLanguageLevel;
    @NotNull
    private String myCompileOutputPath;

    public JavaProjectData(@NotNull ProjectSystemId owner, @NotNull String compileOutputPath) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/externalSystem/JavaProjectData", "<init>"));
        }
        if (compileOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileOutputPath", "com/intellij/externalSystem/JavaProjectData", "<init>"));
        }
        super(owner);
        this.myJdkVersion = DEFAULT_JDK_VERSION;
        this.myLanguageLevel = DEFAULT_LANGUAGE_LEVEL;
        this.myCompileOutputPath = compileOutputPath;
    }

    @NotNull
    public String getCompileOutputPath() {
        String string = this.myCompileOutputPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalSystem/JavaProjectData", "getCompileOutputPath"));
        }
        return string;
    }

    public void setCompileOutputPath(@NotNull String compileOutputPath) {
        if (compileOutputPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileOutputPath", "com/intellij/externalSystem/JavaProjectData", "setCompileOutputPath"));
        }
        this.myCompileOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)compileOutputPath);
    }

    @NotNull
    public JavaSdkVersion getJdkVersion() {
        JavaSdkVersion javaSdkVersion = this.myJdkVersion;
        if (javaSdkVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalSystem/JavaProjectData", "getJdkVersion"));
        }
        return javaSdkVersion;
    }

    public void setJdkVersion(@NotNull JavaSdkVersion jdkVersion) {
        if (jdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkVersion", "com/intellij/externalSystem/JavaProjectData", "setJdkVersion"));
        }
        this.myJdkVersion = jdkVersion;
    }

    public void setJdkVersion(@Nullable String jdk) {
        if (jdk == null) {
            return;
        }
        try {
            int version = Integer.parseInt(jdk.trim());
            if (this.applyJdkVersion(version)) {
                return;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        Matcher matcher = JDK_VERSION_PATTERN.matcher(jdk);
        if (!matcher.matches()) {
            return;
        }
        String versionAsString = matcher.group(1);
        try {
            this.applyJdkVersion(Integer.parseInt(versionAsString));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public boolean applyJdkVersion(int version) {
        if (version < 0 || version >= JavaSdkVersion.values().length) {
            LOG.warn(String.format("Unsupported jdk version detected (%d). Expected to get number from range [0; %d]", version, JavaSdkVersion.values().length));
            return false;
        }
        for (JavaSdkVersion sdkVersion : JavaSdkVersion.values()) {
            if (sdkVersion.ordinal() != version) continue;
            this.myJdkVersion = sdkVersion;
            return true;
        }
        assert (false) : version + ", max value: " + JavaSdkVersion.values().length;
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalSystem/JavaProjectData", "getLanguageLevel"));
        }
        return languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/externalSystem/JavaProjectData", "setLanguageLevel"));
        }
        this.myLanguageLevel = level;
    }

    public void setLanguageLevel(@Nullable String languageLevel) {
        Matcher matcher;
        LanguageLevel level = LanguageLevel.parse((String)languageLevel);
        if (level == null && (matcher = JDK_VERSION_PATTERN.matcher(languageLevel)).matches()) {
            String versionAsString = matcher.group(1);
            level = LanguageLevel.parse((String)("1." + versionAsString));
        }
        if (level != null) {
            this.myLanguageLevel = level;
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myJdkVersion.hashCode();
        result = 31 * result + this.myLanguageLevel.hashCode();
        result = 31 * result + this.myCompileOutputPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaProjectData project = (JavaProjectData)((Object)o);
        if (!this.myCompileOutputPath.equals(project.myCompileOutputPath)) {
            return false;
        }
        if (this.myJdkVersion != project.myJdkVersion) {
            return false;
        }
        return this.myLanguageLevel == project.myLanguageLevel;
    }

    public String toString() {
        return "java project";
    }
}

