/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFilePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/JavaFilePasteProvider", "performPaste"));
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null) {
            return;
        }
        final PsiJavaFile javaFile = JavaFilePasteProvider.createJavaFileFromClipboardContent(project);
        if (javaFile == null) {
            return;
        }
        PsiClass[] classes = javaFile.getClasses();
        if (classes.length < 1) {
            return;
        }
        final PsiDirectory targetDir = ideView.getOrChooseDirectory();
        if (targetDir == null) {
            return;
        }
        PsiClass publicClass = classes[0];
        for (PsiClass aClass : classes) {
            if (!aClass.hasModifierProperty("public")) continue;
            publicClass = aClass;
            break;
        }
        final PsiClass mainClass = publicClass;
        new WriteCommandAction(project, "Paste class '" + mainClass.getName() + "'", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                PsiFile file;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/JavaFilePasteProvider$1", "run"));
                }
                try {
                    file = targetDir.createFile(mainClass.getName() + ".java");
                }
                catch (IncorrectOperationException e) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                if (document != null) {
                    document.setText((CharSequence)javaFile.getText());
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                }
                if (file instanceof PsiJavaFile) {
                    JavaFilePasteProvider.updatePackageStatement((PsiJavaFile)file, targetDir);
                }
                new OpenFileDescriptor(project, file.getVirtualFile()).navigate(true);
            }
        }.execute();
    }

    private static void updatePackageStatement(final PsiJavaFile javaFile, PsiDirectory targetDir) {
        final PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDir);
        if (aPackage == null) {
            return;
        }
        final PsiPackageStatement oldStatement = javaFile.getPackageStatement();
        final Project project = javaFile.getProject();
        if (oldStatement != null && !oldStatement.getPackageName().equals(aPackage.getQualifiedName()) || oldStatement == null && aPackage.getQualifiedName().length() > 0) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    try {
                        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                        PsiPackageStatement newStatement = factory.createPackageStatement(aPackage.getQualifiedName());
                        if (oldStatement != null) {
                            oldStatement.replace((PsiElement)newStatement);
                        } else {
                            PsiElement addedStatement = javaFile.addAfter((PsiElement)newStatement, null);
                            TextRange textRange = addedStatement.getTextRange();
                            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)javaFile, textRange.getStartOffset(), textRange.getEndOffset() + 1);
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                }
            }, "Updating package statement", null);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/JavaFilePasteProvider", "isPastePossible"));
        }
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/JavaFilePasteProvider", "isPasteEnabled"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null || ideView.getDirectories().length == 0) {
            return false;
        }
        PsiJavaFile file = JavaFilePasteProvider.createJavaFileFromClipboardContent(project);
        return file != null && file.getClasses().length >= 1;
    }

    @Nullable
    private static PsiJavaFile createJavaFileFromClipboardContent(Project project) {
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return text != null ? (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("A.java", (Language)JavaLanguage.INSTANCE, (CharSequence)text) : null;
    }
}

