/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.LastStorageChooserForWrite;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportSettingsAction
extends AnAction
implements DumbAware {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@Nullable AnActionEvent e) {
        ApplicationManager.getApplication().saveSettings();
        MultiMap<File, ExportableComponent> fileToComponents = ExportSettingsAction.getExportableComponentsMap(true);
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(fileToComponents, true, IdeBundle.message((String)"title.select.components.to.export", (Object[])new Object[0]), IdeBundle.message((String)"prompt.please.check.all.components.to.export", (Object[])new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        Set<ExportableComponent> markedComponents = dialog.getExportableComponents();
        if (markedComponents.isEmpty()) {
            return;
        }
        THashSet exportFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (ExportableComponent markedComponent : markedComponents) {
            ContainerUtil.addAll((Collection)exportFiles, (Object[])markedComponent.getExportFiles());
        }
        File saveFile = dialog.getExportFile();
        try {
            int ret;
            if (saveFile.exists() && (ret = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.overwrite.settings.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)saveFile.getPath())}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
                return;
            }
            JarOutputStream output = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(saveFile)));
            try {
                File configPath = new File(PathManager.getConfigPath());
                HashSet<String> writtenItemRelativePaths = new HashSet<String>();
                for (File file : exportFiles) {
                    String rPath = FileUtil.getRelativePath((File)configPath, (File)file);
                    assert (rPath != null);
                    String relativePath = FileUtil.toSystemIndependentName((String)rPath);
                    if (!file.exists()) continue;
                    ZipUtil.addFileOrDirRecursively((ZipOutputStream)output, (File)saveFile, (File)file, (String)relativePath, null, writtenItemRelativePaths);
                }
                ExportSettingsAction.exportInstalledPlugins(saveFile, output, writtenItemRelativePaths);
                File magicFile = new File(FileUtil.getTempDirectory(), "IntelliJ IDEA Global Settings");
                FileUtil.createIfDoesntExist((File)magicFile);
                magicFile.deleteOnExit();
                ZipUtil.addFileToZip((ZipOutputStream)output, (File)magicFile, (String)"IntelliJ IDEA Global Settings", writtenItemRelativePaths, null);
            }
            finally {
                output.close();
            }
            ShowFilePathAction.showDialog(ExportSettingsAction.getEventProject((AnActionEvent)e), IdeBundle.message((String)"message.settings.exported.successfully", (Object[])new Object[0]), IdeBundle.message((String)"title.export.successful", (Object[])new Object[0]), saveFile, null);
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.writing.settings", (Object[])new Object[]{e1.toString()}), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }

    private static void exportInstalledPlugins(File saveFile, JarOutputStream output, HashSet<String> writtenItemRelativePaths) throws IOException {
        ArrayList<String> oldPlugins = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (descriptor.isBundled() || !descriptor.isEnabled()) continue;
            oldPlugins.add(descriptor.getPluginId().getIdString());
        }
        if (!oldPlugins.isEmpty()) {
            File tempFile = File.createTempFile("installed", "plugins");
            tempFile.deleteOnExit();
            PluginManagerCore.savePluginsList(oldPlugins, false, tempFile);
            ZipUtil.addDirToZipRecursively((ZipOutputStream)output, (File)saveFile, (File)tempFile, (String)"/installed.txt", null, writtenItemRelativePaths);
        }
    }

    @NotNull
    public static MultiMap<File, ExportableComponent> getExportableComponentsMap(final boolean onlyExisting) {
        ExportableApplicationComponent[] components1 = (ExportableApplicationComponent[])ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class);
        List components2 = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        final MultiMap result = MultiMap.createSet();
        for (ExportableComponent component : ContainerUtil.concat(Arrays.asList(components1), (List)components2)) {
            for (File exportFile : component.getExportFiles()) {
                result.putValue((Object)exportFile, (Object)component);
            }
        }
        if (onlyExisting) {
            Iterator it = result.keySet().iterator();
            while (it.hasNext()) {
                if (((File)it.next()).exists()) continue;
                it.remove();
            }
        }
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        final StateStorageManager storageManager = application.getStateStore().getStateStorageManager();
        ServiceManagerImpl.processAllImplementationClasses(application, new PairProcessor<Class<?>, PluginDescriptor>(){

            public boolean process(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/actions/ExportSettingsAction$1", "process"));
                }
                State stateAnnotation = aClass.getAnnotation(State.class);
                if (stateAnnotation != null && !StringUtil.isEmpty((String)stateAnnotation.name())) {
                    int storageIndex;
                    if (ExportableComponent.class.isAssignableFrom(aClass)) {
                        return true;
                    }
                    Storage[] storages = stateAnnotation.storages();
                    if (storages.length == 1) {
                        storageIndex = 0;
                    } else if (storages.length > 1 && stateAnnotation.storageChooser() == LastStorageChooserForWrite.class) {
                        storageIndex = storages.length - 1;
                    } else {
                        return true;
                    }
                    Storage storage = storages[storageIndex];
                    if (storage.roamingType() != RoamingType.DISABLED && storage.storageClass().equals(StateStorage.class) && storage.scheme() == StorageScheme.DEFAULT && !StringUtil.isEmpty((String)storage.file()) && storage.file().startsWith("$APP_CONFIG$")) {
                        File file = new File(storageManager.expandMacros(storage.file()));
                        if (!onlyExisting || file.exists()) {
                            result.putValue((Object)file, (Object)new MyExportableComponent(file, ExportSettingsAction.getExportableComponentPresentableName(stateAnnotation.name(), aClass, pluginDescriptor)));
                        }
                    }
                }
                return true;
            }
        });
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentsMap"));
        }
        return multiMap;
    }

    @NotNull
    private static String getExportableComponentPresentableName(@NotNull String defaultName, @NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
        ResourceBundle bundle;
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentPresentableName"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentPresentableName"));
        }
        String resourceBundleName = pluginDescriptor != null && pluginDescriptor instanceof IdeaPluginDescriptor && !"com.intellij".equals(pluginDescriptor.getPluginId().getIdString()) ? ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName() : "messages.OptionsBundle";
        if (resourceBundleName == null) {
            String string = defaultName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentPresentableName"));
            }
            return string;
        }
        ClassLoader classLoader = pluginDescriptor == null ? null : pluginDescriptor.getPluginClassLoader();
        ClassLoader classLoader2 = classLoader = classLoader == null ? aClass.getClassLoader() : classLoader;
        if (classLoader != null && (bundle = AbstractBundle.getResourceBundle((String)resourceBundleName, (ClassLoader)classLoader)) != null) {
            String string = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentPresentableName"));
            }
            return string;
        }
        String string = defaultName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction", "getExportableComponentPresentableName"));
        }
        return string;
    }

    private static final class MyExportableComponent
    implements ExportableComponent {
        private final File file;
        private final String name;

        public MyExportableComponent(@NotNull File file, @NotNull String name) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ExportSettingsAction$MyExportableComponent", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/actions/ExportSettingsAction$MyExportableComponent", "<init>"));
            }
            this.file = file;
            this.name = name;
        }

        @NotNull
        public File[] getExportFiles() {
            File[] fileArray = new File[]{this.file};
            if (fileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction$MyExportableComponent", "getExportFiles"));
            }
            return fileArray;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ExportSettingsAction$MyExportableComponent", "getPresentableName"));
            }
            return string;
        }
    }
}

