/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleAction
extends AnAction {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";

    public void actionPerformed(AnActionEvent e) {
        Project project = ImportModuleAction.getEventProject((AnActionEvent)e);
        ImportModuleAction.doImport(project);
    }

    public static List<Module> doImport(Project project) {
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project, null);
        if (wizard == null) {
            return Collections.emptyList();
        }
        if (wizard.getStepCount() > 0 && !wizard.showAndGet()) {
            return Collections.emptyList();
        }
        return ImportModuleAction.createFromWizard(project, wizard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Module> createFromWizard(Project project, AbstractProjectWizard wizard) {
        if (project == null && wizard.getStepCount() > 0) {
            Project newProject = NewProjectUtil.createFromWizard(wizard, null);
            return newProject == null ? Collections.emptyList() : Arrays.asList(ModuleManager.getInstance((Project)newProject).getModules());
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            if (wizard.getStepCount() > 0) {
                Module module = new NewModuleAction().createModuleFromWizard(project, null, wizard);
                List<Module> list = Collections.singletonList(module);
                return list;
            }
            List list = projectBuilder.commit(project);
            return list;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(Project project, Component dialogParent) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Select File or Directory to Import");
        ProjectImportProvider[] providers = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        String description = ImportModuleAction.getFileChooserDescription(project);
        descriptor.setDescription(description);
        return ImportModuleAction.selectFileAndCreateWizard(project, dialogParent, descriptor, providers);
    }

    @Nullable
    public static AddModuleWizard selectFileAndCreateWizard(Project project, @Nullable Component dialogParent, @NotNull FileChooserDescriptor descriptor, ProjectImportProvider[] providers) {
        VirtualFile[] files;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/actions/ImportModuleAction", "selectFileAndCreateWizard"));
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor, project, dialogParent);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files = chooser.choose(project, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file.getPath());
        return ImportModuleAction.createImportWizard(project, dialogParent, file, providers);
    }

    public static String getFileChooserDescription(final Project project) {
        Object[] providers = (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions();
        List list = ContainerUtil.filter((Object[])providers, (Condition)new Condition<ProjectImportProvider>(){

            public boolean value(ProjectImportProvider provider) {
                return project != null || provider.canCreateNewProject();
            }
        });
        StringBuilder builder = new StringBuilder("<html>Select ");
        boolean first = true;
        if (list.size() > 1) {
            for (ProjectImportProvider provider : list) {
                String sample = provider.getFileSample();
                if (sample == null) continue;
                if (!first) {
                    builder.append(", <br>");
                } else {
                    first = false;
                }
                builder.append(sample);
            }
        }
        builder.append(".</html>");
        return builder.toString();
    }

    @Nullable
    public static AddModuleWizard createImportWizard(final Project project, @Nullable Component dialogParent, final VirtualFile file, ProjectImportProvider ... providers) {
        List available = ContainerUtil.filter((Object[])providers, (Condition)new Condition<ProjectImportProvider>(){

            public boolean value(ProjectImportProvider provider) {
                return provider.canImport(file, project);
            }
        });
        if (available.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)("Cannot import anything from " + file.getPath()), (String)"Cannot Import");
            return null;
        }
        String path = available.size() == 1 ? ((ProjectImportProvider)available.get(0)).getPathToBeImported(file) : ProjectImportProvider.getDefaultPath(file);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[available.size()]);
        return dialogParent == null ? new AddModuleWizard(project, path, availableProviders) : new AddModuleWizard(project, dialogParent, path, availableProviders);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(ImportModuleAction.getEventProject((AnActionEvent)e) != null);
    }

    public boolean isDumbAware() {
        return true;
    }
}

