/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplatePanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateDialog
extends DialogWrapper {
    @NotNull
    private final PsiDirectory myDirectory;
    @NotNull
    private final Project myProject;
    private PsiElement myCreatedElement;
    private final CreateFromTemplatePanel myAttrPanel;
    private final JComponent myAttrComponent;
    @NotNull
    private final FileTemplate myTemplate;
    private final Properties myDefaultProperties;

    public CreateFromTemplateDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull FileTemplate template, @Nullable AttributesDefaults attributesDefaults, @Nullable Properties defaultProperties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog", "<init>"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog", "<init>"));
        }
        super(project, true);
        this.myDirectory = directory;
        this.myProject = project;
        this.myTemplate = template;
        this.setTitle(IdeBundle.message((String)"title.new.from.template", (Object[])new Object[]{template.getName()}));
        this.myDefaultProperties = defaultProperties == null ? FileTemplateManager.getInstance().getDefaultProperties(project) : defaultProperties;
        FileTemplateUtil.fillDefaultProperties(this.myDefaultProperties, directory);
        boolean mustEnterName = FileTemplateUtil.findHandler(template).isNameRequired();
        if (attributesDefaults != null && attributesDefaults.isFixedName()) {
            this.myDefaultProperties.setProperty("NAME", attributesDefaults.getDefaultFileName());
            mustEnterName = false;
        }
        String[] unsetAttributes = null;
        try {
            unsetAttributes = this.myTemplate.getUnsetAttributes(this.myDefaultProperties);
        }
        catch (ParseException e) {
            this.showErrorDialog((Exception)((Object)e));
        }
        if (unsetAttributes != null) {
            this.myAttrPanel = new CreateFromTemplatePanel(unsetAttributes, mustEnterName, attributesDefaults);
            this.myAttrComponent = this.myAttrPanel.getComponent();
            this.init();
        } else {
            this.myAttrPanel = null;
            this.myAttrComponent = null;
        }
    }

    public PsiElement create() {
        if (this.myAttrPanel != null) {
            if (this.myAttrPanel.hasSomethingToAsk()) {
                this.show();
                return this.myCreatedElement;
            }
            this.doCreate(null);
        }
        this.close(0);
        return this.myCreatedElement;
    }

    protected void doOKAction() {
        String fileName = this.myAttrPanel.getFileName();
        if (fileName != null && fileName.length() == 0) {
            Messages.showMessageDialog((Component)this.myAttrComponent, (String)IdeBundle.message((String)"error.please.enter.a.file.name", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.doCreate(fileName);
        if (this.myCreatedElement != null) {
            super.doOKAction();
        }
    }

    private void doCreate(@Nullable String fileName) {
        try {
            String newName = fileName;
            PsiDirectory directory = this.myDirectory;
            if (fileName != null) {
                final String finalFileName = fileName;
                CreateFileAction.MkDirs mkDirs = (CreateFileAction.MkDirs)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<CreateFileAction.MkDirs>(){

                    public CreateFileAction.MkDirs compute() {
                        return new CreateFileAction.MkDirs(finalFileName, CreateFromTemplateDialog.this.myDirectory);
                    }
                });
                newName = mkDirs.newName;
                directory = mkDirs.directory;
            }
            this.myCreatedElement = FileTemplateUtil.createFromTemplate(this.myTemplate, newName, this.myAttrPanel.getProperties(this.myDefaultProperties), directory);
        }
        catch (Exception e) {
            this.showErrorDialog(e);
        }
    }

    public Properties getEnteredProperties() {
        return this.myAttrPanel.getProperties(new Properties());
    }

    private void showErrorDialog(Exception e) {
        Messages.showMessageDialog((Project)this.myProject, (String)this.filterMessage(e.getMessage()), (String)this.getErrorMessage(), (Icon)Messages.getErrorIcon());
    }

    private String getErrorMessage() {
        return FileTemplateUtil.findHandler(this.myTemplate).getErrorMessage();
    }

    @Nullable
    private String filterMessage(String message) {
        String ioExceptionPrefix;
        if (message == null) {
            message = "unknown error";
        }
        if (message.startsWith(ioExceptionPrefix = "java.io.IOException:")) {
            return message.substring(ioExceptionPrefix.length());
        }
        if (message.contains("File already exists")) {
            return message;
        }
        return IdeBundle.message((String)"error.unable.to.parse.template.message", (Object[])new Object[]{this.myTemplate.getName(), message});
    }

    protected JComponent createCenterPanel() {
        this.myAttrPanel.ensureFitToScreen(200, 200);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)this.myAttrComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return centerPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myAttrComponent);
    }
}

