/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.ScratchpadManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewScratchFileAction
extends AnAction
implements DumbAware {
    public static final int MAX_VISIBLE_SIZE = 20;

    public NewScratchFileAction() {
        super("New Scratch File...", null, null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "update"));
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && Registry.is((String)"ide.scratch.enabled"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "actionPerformed"));
        }
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        Language previous = ScratchpadManager.getInstance(project).getLatestLanguage();
        ListPopup popup = NewScratchFileAction.buildLanguagePopup(previous, new Consumer<Language>(){

            public void consume(Language language) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
                VirtualFile file = ScratchpadManager.getInstance(project).createScratchFile(language);
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        });
        popup.showCenteredInCurrentWindow(project);
    }

    @NotNull
    static ListPopup buildLanguagePopup(@Nullable Language previous, final Consumer<Language> onChoosen) {
        List languages = LanguageUtil.getFileLanguages();
        BaseListPopupStep<Language> step = new BaseListPopupStep<Language>("Choose Language", languages){

            @NotNull
            public String getTextFor(Language value) {
                String string = value.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction$2", "getTextFor"));
                }
                return string;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(Language selectedValue, boolean finalChoice) {
                onChoosen.consume((Object)selectedValue);
                return null;
            }

            public Icon getIconFor(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }
        };
        step.setDefaultOptionIndex(Math.max(0, languages.indexOf(ObjectUtils.chooseNotNull((Object)previous, (Object)StdLanguages.TEXT))));
        ListPopup listPopup = NewScratchFileAction.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "buildLanguagePopup"));
        }
        return listPopup;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/scratch/NewScratchFileAction", "tweakSizeToPreferred"));
        }
        int nameLen = 0;
        ListPopupStep step = popup.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getMinimumSize();
            size.height *= 20;
            popup.setSize(size);
        }
        ListPopup listPopup = popup;
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/NewScratchFileAction", "tweakSizeToPreferred"));
        }
        return listPopup;
    }
}

