/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="UsageTrigger", storages={@Storage(file="$APP_CONFIG$/statistics.application.usages.xml", roamingType=RoamingType.DISABLED)})
public class UsageTrigger
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static void trigger(@NotNull String feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/internal/statistic/UsageTrigger", "trigger"));
        }
        UsageTrigger.getInstance().doTrigger(feature);
    }

    private static UsageTrigger getInstance() {
        return (UsageTrigger)ServiceManager.getService(UsageTrigger.class);
    }

    private void doTrigger(String feature) {
        ConvertUsagesUtil.assertDescriptorName(feature);
        Integer count = this.myState.myValues.get(feature);
        if (count == null) {
            this.myState.myValues.put(feature, 1);
        } else {
            this.myState.myValues.put(feature, count + 1);
        }
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static class MyCollector
    extends UsagesCollector {
        private static final GroupDescriptor GROUP = GroupDescriptor.create("features counts", 100.0);

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages(@Nullable Project project) {
            State state = UsageTrigger.getInstance().getState();
            Set set = ContainerUtil.map2Set(state.myValues.entrySet(), (Function)new Function<Map.Entry<String, Integer>, UsageDescriptor>(){

                public UsageDescriptor fun(Map.Entry<String, Integer> e) {
                    return new UsageDescriptor(e.getKey(), e.getValue());
                }
            });
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/UsageTrigger$MyCollector", "getUsages"));
            }
            return set;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GROUP;
            if (groupDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/UsageTrigger$MyCollector", "getGroupId"));
            }
            return groupDescriptor;
        }
    }

    public static class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="feature", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

