/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptors;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarStatisticsService
extends SettingsConnectionService {
    private static final String FILE_NAME = "library-jar-statistics.xml";
    private static final String DEFAULT_SETTINGS_URL = "http://jetbrains.com/idea/library-jar-statistics.xml";
    private static final String DEFAULT_SERVICE_URL = "http://frameworks.jetbrains.com/statistics";
    private static final LibraryJarStatisticsService myInstance = new LibraryJarStatisticsService();
    private LibraryJarDescriptor[] myDescriptors;

    public static LibraryJarStatisticsService getInstance() {
        return myInstance;
    }

    protected LibraryJarStatisticsService() {
        super(DEFAULT_SETTINGS_URL, DEFAULT_SERVICE_URL);
    }

    @NotNull
    public LibraryJarDescriptor[] getTechnologyDescriptors() {
        if (this.myDescriptors == null) {
            URL url = this.createVersionsUrl();
            if (url == null) {
                LibraryJarDescriptor[] libraryJarDescriptorArray = new LibraryJarDescriptor[]{};
                if (libraryJarDescriptorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/libraryJar/LibraryJarStatisticsService", "getTechnologyDescriptors"));
                }
                return libraryJarDescriptorArray;
            }
            LibraryJarDescriptors descriptors = LibraryJarStatisticsService.deserialize(url);
            LibraryJarDescriptor[] libraryJarDescriptorArray = this.myDescriptors = descriptors == null ? new LibraryJarDescriptor[]{} : descriptors.getDescriptors();
        }
        if (this.myDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/libraryJar/LibraryJarStatisticsService", "getTechnologyDescriptors"));
        }
        return this.myDescriptors;
    }

    @Nullable
    private static LibraryJarDescriptors deserialize(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        LibraryJarDescriptors libraryJarDescriptors = null;
        try {
            libraryJarDescriptors = (LibraryJarDescriptors)XmlSerializer.deserialize((URL)url, LibraryJarDescriptors.class);
        }
        catch (XmlSerializationException xmlSerializationException) {
            // empty catch block
        }
        return libraryJarDescriptors;
    }

    @Nullable
    private URL createVersionsUrl() {
        String serviceUrl = this.getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + FILE_NAME;
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException ignored) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

