/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.DefaultsStateStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseFileConfigurableStoreImpl
extends ComponentStoreImpl {
    @NonNls
    protected static final String VERSION_OPTION = "version";
    @NonNls
    public static final String ATTRIBUTE_NAME = "name";
    private static final List<String> ourConversionProblemsStorage = new SmartList();
    private final ComponentManager myComponentManager;
    private final DefaultsStateStorage myDefaultsStateStorage;
    private StateStorageManager myStateStorageManager;

    protected BaseFileConfigurableStoreImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "<init>"));
        }
        this.myComponentManager = componentManager;
        this.myDefaultsStateStorage = new DefaultsStateStorage(PathMacroManager.getInstance(this.myComponentManager));
    }

    @NotNull
    public ComponentManager getComponentManager() {
        ComponentManager componentManager = this.myComponentManager;
        if (componentManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "getComponentManager"));
        }
        return componentManager;
    }

    protected abstract XmlElementStorage getMainStorage();

    @Nullable
    static List<String> getConversionProblemsStorage() {
        return ourConversionProblemsStorage;
    }

    @Override
    public void load() throws IOException, StateStorageException {
        this.getMainStorageData();
    }

    public BaseStorageData getMainStorageData() throws StateStorageException {
        return (BaseStorageData)this.getMainStorage().getStorageData();
    }

    @Override
    @Nullable
    protected StateStorage getDefaultsStorage() {
        return this.myDefaultsStateStorage;
    }

    @Override
    @NotNull
    public StateStorageManager getStateStorageManager() {
        if (this.myStateStorageManager == null) {
            this.myStateStorageManager = this.createStateStorageManager();
        }
        StateStorageManager stateStorageManager = this.myStateStorageManager;
        if (stateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl", "getStateStorageManager"));
        }
        return stateStorageManager;
    }

    @NotNull
    protected abstract StateStorageManager createStateStorageManager();

    protected static class BaseStorageData
    extends FileBasedStorage.FileStorageData {
        protected int myVersion;

        public BaseStorageData(String rootElementName) {
            super(rootElementName);
        }

        protected BaseStorageData(BaseStorageData storageData) {
            super(storageData);
            this.myVersion = 4;
        }

        @Override
        public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "load"));
            }
            super.load(rootElement, pathMacroSubstitutor, intern);
            String v = rootElement.getAttributeValue(BaseFileConfigurableStoreImpl.VERSION_OPTION);
            this.myVersion = v != null ? Integer.parseInt(v) : 4;
        }

        @Override
        @NotNull
        protected Element save(@NotNull Map<String, Element> newLiveStates) {
            if (newLiveStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "save"));
            }
            Element root = super.save(newLiveStates);
            if (root == null) {
                root = new Element(this.myRootElementName);
            }
            root.setAttribute(BaseFileConfigurableStoreImpl.VERSION_OPTION, Integer.toString(this.myVersion));
            Element element = root;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "save"));
            }
            return element;
        }

        @Override
        public StorageData clone() {
            return new BaseStorageData(this);
        }

        @Override
        @Nullable
        public Set<String> getChangedComponentNames(@NotNull StorageData newStorageData, @Nullable PathMacroSubstitutor substitutor) {
            if (newStorageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStorageData", "com/intellij/openapi/components/impl/stores/BaseFileConfigurableStoreImpl$BaseStorageData", "getChangedComponentNames"));
            }
            BaseStorageData data = (BaseStorageData)newStorageData;
            if (this.myVersion != data.myVersion) {
                return null;
            }
            return super.getChangedComponentNames(newStorageData, substitutor);
        }
    }
}

