/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.LastStorageChooserForWrite;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.InvalidComponentDataException;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.components.store.ComponentSaveSession;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentStoreImpl
implements IComponentStore.Reloadable {
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);
    private final Map<String, Object> myComponents = Collections.synchronizedMap(new THashMap());
    private final List<SettingsSavingComponent> mySettingsSavingComponents = new CopyOnWriteArrayList<SettingsSavingComponent>();

    @Nullable
    protected abstract StateStorage getDefaultsStorage();

    @Override
    public void initComponent(final @NotNull Object component, boolean service) {
        boolean isSerializable;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initComponent"));
        }
        if (component instanceof SettingsSavingComponent) {
            this.mySettingsSavingComponents.add((SettingsSavingComponent)component);
        }
        boolean bl = isSerializable = component instanceof JDOMExternalizable || component instanceof PersistentStateComponent;
        if (!isSerializable) {
            return;
        }
        try {
            ApplicationManagerEx.getApplicationEx().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (component instanceof PersistentStateComponent) {
                        ComponentStoreImpl.this.initPersistentComponent((PersistentStateComponent)component, false, false);
                    } else {
                        ComponentStoreImpl.this.initJdomExternalizable((JDOMExternalizable)component);
                    }
                }
            });
        }
        catch (StateStorageException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @Nullable
    public final ComponentSaveSession startSave() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        StateStorageManager storageManager = this.getStateStorageManager();
        StateStorageManager.ExternalizationSession externalizationSession = storageManager.startExternalization();
        if (externalizationSession == null) {
            return null;
        }
        Object[] names = ArrayUtilRt.toStringArray(this.myComponents.keySet());
        Arrays.sort(names);
        for (Object name : names) {
            Object component = this.myComponents.get(name);
            if (component instanceof PersistentStateComponent) {
                this.commitPersistentComponent((PersistentStateComponent)component, externalizationSession);
                continue;
            }
            if (!(component instanceof JDOMExternalizable)) continue;
            externalizationSession.setStateInOldStorage(component, ComponentManagerImpl.getComponentName(component), component);
        }
        StateStorage.SaveSession storageManagerSaveSession = storageManager.startSave(externalizationSession);
        if (storageManagerSaveSession == null) {
            return null;
        }
        SaveSessionImpl session = this.createSaveSession();
        session.myStorageManagerSaveSession = storageManagerSaveSession;
        return session;
    }

    protected SaveSessionImpl createSaveSession() {
        return new SaveSessionImpl();
    }

    private <T> void commitPersistentComponent(@NotNull PersistentStateComponent<T> persistentStateComponent, @NotNull StateStorageManager.ExternalizationSession session) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        Object state = persistentStateComponent.getState();
        if (state != null) {
            Storage[] storageSpecs = this.getComponentStorageSpecs(persistentStateComponent, StateStorageOperation.WRITE);
            session.setState(storageSpecs, persistentStateComponent, ComponentStoreImpl.getComponentName(persistentStateComponent), state);
        }
    }

    @Nullable
    private String initJdomExternalizable(@NotNull JDOMExternalizable component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initJdomExternalizable"));
        }
        String componentName = ComponentManagerImpl.getComponentName(component);
        this.doAddComponent(componentName, component);
        if (this.optimizeTestLoading()) {
            return componentName;
        }
        this.loadJdomDefaults(component, componentName);
        StateStorage stateStorage = this.getStateStorageManager().getOldStorage(component, componentName, StateStorageOperation.READ);
        if (stateStorage == null) {
            return null;
        }
        Element element = ComponentStoreImpl.getJdomState(component, componentName, stateStorage);
        if (element == null) {
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading configuration for " + component.getClass());
            }
            component.readExternal(element);
        }
        catch (InvalidDataException e) {
            throw new InvalidComponentDataException(e);
        }
        this.validateUnusedMacros(componentName, true);
        return componentName;
    }

    private void doAddComponent(String componentName, Object component) {
        Object existing = this.myComponents.get(componentName);
        if (existing != null && existing != component) {
            LOG.error("Conflicting component name '" + componentName + "': " + existing.getClass() + " and " + component.getClass());
        }
        this.myComponents.put(componentName, component);
    }

    private void loadJdomDefaults(@NotNull Object component, @NotNull String componentName) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        try {
            StateStorage defaultsStorage = this.getDefaultsStorage();
            if (defaultsStorage == null) {
                return;
            }
            Element defaultState = ComponentStoreImpl.getJdomState(component, componentName, defaultsStorage);
            if (defaultState == null) {
                return;
            }
            ((JDOMExternalizable)component).readExternal(defaultState);
        }
        catch (Exception e) {
            LOG.error("Cannot load defaults for " + component.getClass(), (Throwable)e);
        }
    }

    @Nullable
    private static Element getJdomState(Object component, @NotNull String componentName, @NotNull StateStorage defaultsStorage) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getJdomState"));
        }
        if (defaultsStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultsStorage", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getJdomState"));
        }
        ComponentRoamingManager roamingManager = ComponentRoamingManager.getInstance();
        if (component instanceof RoamingTypeDisabled) {
            roamingManager.setRoamingType(componentName, RoamingType.DISABLED);
        }
        return (Element)defaultsStorage.getState(component, componentName, Element.class, null);
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    private void validateUnusedMacros(@Nullable String componentName, boolean service) {
        TrackingPathMacroSubstitutor substitutor;
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() && service && componentName != null && project.isInitialized() && (substitutor = this.getStateStorageManager().getMacroSubstitutor()) != null) {
            StorageUtil.notifyUnknownMacros(substitutor, project, componentName);
        }
    }

    private <T> String initPersistentComponent(@NotNull PersistentStateComponent<T> component, boolean reloadData, boolean isReinit) {
        Storage[] storageSpecs;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initPersistentComponent"));
        }
        State spec = ComponentStoreImpl.getStateSpec(component);
        String name = spec.name();
        ComponentRoamingManager.getInstance().setRoamingType(name, spec.roamingType());
        if (!isReinit) {
            this.doAddComponent(name, component);
        }
        if (this.optimizeTestLoading()) {
            return name;
        }
        Class<T> stateClass = ComponentStoreImpl.getComponentStateClass(component);
        Object state = null;
        StateStorage defaultsStorage = this.getDefaultsStorage();
        if (defaultsStorage != null) {
            state = defaultsStorage.getState(component, name, stateClass, null);
        }
        for (Storage storageSpec : storageSpecs = this.getComponentStorageSpecs(component, StateStorageOperation.READ)) {
            StateStorage stateStorage = this.getStateStorageManager().getStateStorage(storageSpec);
            if (stateStorage != null && stateStorage.hasState(component, name, stateClass, reloadData) && (state = stateStorage.getState(component, name, stateClass, state)) instanceof Element) break;
        }
        if (state != null) {
            component.loadState(state);
        }
        this.validateUnusedMacros(name, true);
        return name;
    }

    @NotNull
    private static <T> Class<T> getComponentStateClass(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStateClass"));
        }
        Class<PersistentStateComponent> persistentStateComponentClass = PersistentStateComponent.class;
        Class<?> componentClass = persistentStateComponent.getClass();
        block0: while (true) {
            for (Class<?> anInterface : componentClass.getInterfaces()) {
                if (anInterface.equals(persistentStateComponentClass)) break block0;
            }
            componentClass = componentClass.getSuperclass();
        }
        Type type = ReflectionUtil.resolveVariable(persistentStateComponentClass.getTypeParameters()[0], componentClass);
        assert (type != null);
        Class clazz = ReflectionUtil.getRawType((Type)type);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStateClass"));
        }
        return clazz;
    }

    @NotNull
    public static String getComponentName(@NotNull PersistentStateComponent<?> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        String string = ComponentStoreImpl.getStateSpec(persistentStateComponent).name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        return string;
    }

    @NotNull
    private static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateSpec"));
        }
        Class<?> aClass = persistentStateComponent.getClass();
        State stateSpec = aClass.getAnnotation(State.class);
        if (stateSpec == null) {
            PluginId pluginId = PluginManagerCore.getPluginByClassName(aClass.getName());
            if (pluginId != null) {
                throw new PluginException("No @State annotation found in " + aClass, pluginId);
            }
            throw new RuntimeException("No @State annotation found in " + aClass);
        }
        State state = stateSpec;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateSpec"));
        }
        return state;
    }

    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> persistentStateComponent, StateStorageOperation operation) throws StateStorageException {
        Storage[] storageArray;
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        State stateSpec = ComponentStoreImpl.getStateSpec(persistentStateComponent);
        Storage[] storages = stateSpec.storages();
        if (storages.length == 1) {
            if (storages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storages;
        }
        assert (storages.length > 0);
        Class storageChooserClass = stateSpec.storageChooser();
        if (storageChooserClass == StateStorageChooser.class) {
            StateStorageChooser<PersistentStateComponent<?>> defaultStateStorageChooser = this.getDefaultStateStorageChooser();
            assert (defaultStateStorageChooser != null) : "State chooser not specified for: " + persistentStateComponent.getClass();
            Storage[] storageArray2 = defaultStateStorageChooser.selectStorages(storages, persistentStateComponent, operation);
            if (storageArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storageArray2;
        }
        if (storageChooserClass == LastStorageChooserForWrite.class) {
            Storage[] storageArray3 = LastStorageChooserForWrite.INSTANCE.selectStorages(storages, persistentStateComponent, operation);
            if (storageArray3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storageArray3;
        }
        try {
            StateStorageChooser storageChooser = (StateStorageChooser)ReflectionUtil.newInstance((Class)storageChooserClass, (Class[])new Class[0]);
            storageArray = storageChooser.selectStorages(storages, persistentStateComponent, operation);
        }
        catch (RuntimeException e) {
            throw new StateStorageException((Throwable)e);
        }
        if (storageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        return storageArray;
    }

    protected boolean optimizeTestLoading() {
        return false;
    }

    @Nullable
    protected StateStorageChooser<PersistentStateComponent<?>> getDefaultStateStorageChooser() {
        return null;
    }

    protected static void executeSave(@NotNull StateStorage.SaveSession saveSession, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveSession", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "executeSave"));
        }
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "executeSave"));
        }
        try {
            saveSession.save();
        }
        catch (ReadOnlyModificationException e) {
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)Pair.create((Object)saveSession, (Object)e.getFile()));
        }
    }

    @Override
    public boolean isReloadPossible(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "isReloadPossible"));
        }
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && ComponentStoreImpl.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final Collection<String> getNotReloadableComponents(@NotNull Collection<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getNotReloadableComponents"));
        }
        LinkedHashSet<String> notReloadableComponents = null;
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && ComponentStoreImpl.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            if (notReloadableComponents == null) {
                notReloadableComponents = new LinkedHashSet<String>();
            }
            notReloadableComponents.add(componentName);
        }
        Set<String> set = notReloadableComponents == null ? Collections.emptySet() : notReloadableComponents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getNotReloadableComponents"));
        }
        return set;
    }

    @Override
    public final void reinitComponents(@NotNull Set<String> componentNames, boolean reloadData) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        this.reinitComponents(componentNames, Collections.<String>emptySet(), reloadData);
    }

    protected boolean reinitComponent(@NotNull String componentName, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponent"));
        }
        PersistentStateComponent component = (PersistentStateComponent)this.myComponents.get(componentName);
        if (component == null) {
            return false;
        }
        this.initPersistentComponent(component, reloadData, true);
        return true;
    }

    @NotNull
    protected abstract MessageBus getMessageBus();

    @Override
    @Nullable
    public final Collection<String> reload(@NotNull Collection<Pair<VirtualFile, StateStorage>> changedFiles) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reload"));
        }
        SmartHashSet componentNames = new SmartHashSet();
        for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
            StateStorage storage = (StateStorage)pair.second;
            try {
                storage.analyzeExternalChangesAndUpdateIfNeed(changedFiles, (Set)componentNames);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (componentNames.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<String> notReloadableComponents = this.getNotReloadableComponents((Collection<String>)componentNames);
        this.reinitComponents((Set<String>)componentNames, notReloadableComponents, false);
        return notReloadableComponents.isEmpty() ? null : notReloadableComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reinitComponents(@NotNull Set<String> componentNames, @NotNull Collection<String> notReloadableComponents, boolean reloadData) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        MessageBus messageBus = this.getMessageBus();
        ((BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
        try {
            for (String componentName : componentNames) {
                if (notReloadableComponents.contains(componentName)) continue;
                this.reinitComponent(componentName, reloadData);
            }
        }
        finally {
            ((BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static ReloadComponentStoreStatus reloadStore(@NotNull Collection<Pair<VirtualFile, StateStorage>> causes, @NotNull IComponentStore.Reloadable store) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 5[CATCHBLOCK], 6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean askToRestart(@NotNull IComponentStore.Reloadable store, @NotNull Collection<String> notReloadableComponents, @Nullable Collection<Pair<VirtualFile, StateStorage>> causes) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "askToRestart"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "askToRestart"));
        }
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IApplicationStore ? "Application" : "Project";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (store instanceof IApplicationStore) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (causes != null) {
                for (Pair pair : causes) {
                    StateStorage stateStorage = (StateStorage)pair.getSecond();
                    if (!(stateStorage instanceof XmlElementStorage)) continue;
                    ((XmlElementStorage)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    public static enum ReloadComponentStoreStatus {
        RESTART_AGREED,
        RESTART_CANCELLED,
        ERROR,
        SUCCESS;

    }

    protected class SaveSessionImpl
    implements ComponentSaveSession {
        protected StateStorage.SaveSession myStorageManagerSaveSession;

        protected SaveSessionImpl() {
        }

        @Override
        @NotNull
        public ComponentSaveSession save(@NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
            if (readonlyFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "save"));
            }
            for (SettingsSavingComponent settingsSavingComponent : ComponentStoreImpl.this.mySettingsSavingComponents) {
                try {
                    settingsSavingComponent.save();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            ComponentStoreImpl.executeSave(this.myStorageManagerSaveSession, readonlyFiles);
            SaveSessionImpl saveSessionImpl = this;
            if (saveSessionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "save"));
            }
            return saveSessionImpl;
        }

        @Override
        public void finishSave() {
            ComponentStoreImpl.this.getStateStorageManager().finishSave(this.myStorageManagerSaveSession);
            this.myStorageManagerSaveSession = null;
        }
    }
}

