/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeEditorFontSizeAction
extends AnAction {
    private final int myStep;

    protected ChangeEditorFontSizeAction(@Nullable String text, int increaseStep) {
        super(text);
        this.myStep = increaseStep;
    }

    public void actionPerformed(AnActionEvent e) {
        int size;
        EditorImpl editor = ChangeEditorFontSizeAction.getEditor(e);
        if (editor != null && (size = editor.getFontSize() + this.myStep) >= 8 && size <= 40) {
            editor.setFontSize(size);
        }
    }

    @Nullable
    private static EditorImpl getEditor(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor instanceof EditorImpl) {
            return (EditorImpl)editor;
        }
        return null;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(ChangeEditorFontSizeAction.getEditor(e) != null);
    }

    public static class DecreaseEditorFontSize
    extends ChangeEditorFontSizeAction {
        protected DecreaseEditorFontSize() {
            super(EditorBundle.message((String)"decrease.editor.font", (Object[])new Object[0]), -1);
        }
    }

    public static class IncreaseEditorFontSize
    extends ChangeEditorFontSizeAction {
        protected IncreaseEditorFontSize() {
            super(EditorBundle.message((String)"increase.editor.font", (Object[])new Object[0]), 1);
        }
    }
}

