/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;

public class PasteAction
extends EditorAction {
    public static final DataKey<Producer<Transferable>> TRANSFERABLE_PROVIDER = DataKey.create((String)"PasteTransferableProvider");

    public PasteAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            Producer producer = (Producer)TRANSFERABLE_PROVIDER.getData(dataContext);
            if (!editor.getCaretModel().supportsMultipleCarets() && (editor.isColumnMode() || editor.getSelectionModel().hasBlockSelection())) {
                EditorModificationUtil.pasteTransferableAsBlock((Editor)editor, (Producer)producer);
            } else {
                TextRange range = EditorModificationUtil.pasteTransferable((Editor)editor, (Producer)producer);
                editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)range);
            }
        }
    }
}

