/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import java.util.List;

public class ToggleColumnModeAction
extends ToggleAction
implements DumbAware {
    public void setSelected(AnActionEvent e, boolean state) {
        EditorEx editor = ToggleColumnModeAction.getEditor(e);
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        if (state) {
            LogicalPosition blockEnd;
            LogicalPosition blockStart;
            caretModel.removeSecondaryCarets();
            boolean hasSelection = selectionModel.hasSelection();
            int selStart = selectionModel.getSelectionStart();
            int selEnd = selectionModel.getSelectionEnd();
            if (caretModel.supportsMultipleCarets()) {
                LogicalPosition logicalSelStart = editor.offsetToLogicalPosition(selStart);
                LogicalPosition logicalSelEnd = editor.offsetToLogicalPosition(selEnd);
                int caretOffset = caretModel.getOffset();
                blockStart = selStart == caretOffset ? logicalSelEnd : logicalSelStart;
                blockEnd = selStart == caretOffset ? logicalSelStart : logicalSelEnd;
            } else {
                blockStart = selStart == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor.offsetToLogicalPosition(selStart);
                blockEnd = selEnd == caretModel.getOffset() ? caretModel.getLogicalPosition() : editor.offsetToLogicalPosition(selEnd);
            }
            editor.setColumnMode(true);
            if (hasSelection) {
                selectionModel.setBlockSelection(blockStart, blockEnd);
            } else {
                selectionModel.removeSelection();
            }
        } else {
            int selEnd;
            boolean hasSelection = selectionModel.hasBlockSelection();
            LogicalPosition blockStart = selectionModel.getBlockStart();
            LogicalPosition blockEnd = selectionModel.getBlockEnd();
            int selStart = hasSelection && blockStart != null ? editor.logicalPositionToOffset(blockStart) : 0;
            int n = selEnd = hasSelection && blockEnd != null ? editor.logicalPositionToOffset(blockEnd) : 0;
            if (caretModel.supportsMultipleCarets()) {
                hasSelection = true;
                List allCarets = caretModel.getAllCarets();
                Caret fromCaret = (Caret)allCarets.get(0);
                Caret toCaret = (Caret)allCarets.get(allCarets.size() - 1);
                if (fromCaret == caretModel.getPrimaryCaret()) {
                    Caret tmp = fromCaret;
                    fromCaret = toCaret;
                    toCaret = tmp;
                }
                selStart = fromCaret.getLeadSelectionOffset();
                selEnd = toCaret.getSelectionStart() == toCaret.getLeadSelectionOffset() ? toCaret.getSelectionEnd() : toCaret.getSelectionStart();
            }
            editor.setColumnMode(false);
            caretModel.removeSecondaryCarets();
            if (hasSelection) {
                selectionModel.setSelection(selStart, selEnd);
            } else {
                selectionModel.removeSelection();
            }
        }
    }

    public boolean isSelected(AnActionEvent e) {
        EditorEx ex = ToggleColumnModeAction.getEditor(e);
        return ex != null && ex.isColumnMode();
    }

    private static EditorEx getEditor(AnActionEvent e) {
        return (EditorEx)CommonDataKeys.EDITOR.getData(e.getDataContext());
    }

    public void update(AnActionEvent e) {
        EditorEx editor = ToggleColumnModeAction.getEditor(e);
        if (editor == null || editor.isOneLineMode()) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setVisible(true);
            super.update(e);
        }
    }
}

