/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageCounter {
    private final Map<ProjectSystemId, Map<String, Map<NotificationSource, TObjectIntHashMap<NotificationCategory>>>> map = new HashMap();

    public synchronized void increment(@NotNull String groupName, @NotNull NotificationSource source, @NotNull NotificationCategory category, @NotNull ProjectSystemId projectSystemId) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "increment"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "increment"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "increment"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "increment"));
        }
        TObjectIntHashMap counter = (TObjectIntHashMap)ContainerUtil.getOrCreate((Map)((Map)ContainerUtil.getOrCreate((Map)((Map)ContainerUtil.getOrCreate(this.map, (Object)projectSystemId, (Object)ContainerUtil.newHashMap())), (Object)groupName, (Object)ContainerUtil.newHashMap())), (Object)((Object)source), new MyTObjectIntHashMap());
        if (!counter.increment((Object)category)) {
            counter.put((Object)category, 1);
        }
    }

    public synchronized void remove(@Nullable String groupName, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "remove"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "remove"));
        }
        Map groupMap = (Map)ContainerUtil.getOrCreate(this.map, (Object)projectSystemId, (Object)ContainerUtil.newHashMap());
        if (groupName != null) {
            TObjectIntHashMap counter = (TObjectIntHashMap)ContainerUtil.getOrCreate((Map)((Map)ContainerUtil.getOrCreate((Map)groupMap, (Object)groupName, (Object)ContainerUtil.newHashMap())), (Object)((Object)notificationSource), new MyTObjectIntHashMap());
            counter.clear();
        } else {
            for (Map sourceMap : groupMap.values()) {
                sourceMap.remove((Object)notificationSource);
            }
        }
    }

    public synchronized int getCount(@Nullable String groupName, @NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId projectSystemId) {
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "getCount"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/notification/MessageCounter", "getCount"));
        }
        int count = 0;
        Map groupMap = (Map)ContainerUtil.getOrElse(this.map, (Object)projectSystemId, Collections.emptyMap());
        for (Map.Entry entry : groupMap.entrySet()) {
            TObjectIntHashMap counter;
            if (groupName != null && !groupName.equals(entry.getKey()) || (counter = (TObjectIntHashMap)((Map)entry.getValue()).get((Object)notificationSource)) == null) continue;
            if (notificationCategory == null) {
                for (int aCount : counter.getValues()) {
                    count += aCount;
                }
                continue;
            }
            count = counter.get((Object)notificationCategory);
        }
        return count;
    }

    public String toString() {
        return "MessageCounter{map=" + this.map + '}';
    }

    private static class MyTObjectIntHashMap<K>
    extends TObjectIntHashMap<K> {
        private MyTObjectIntHashMap() {
        }

        public String toString() {
            return Arrays.toString(this._set);
        }
    }
}

