/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.preview;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PreviewManager {
    @Nullable
    public <V, C> C preview(@NotNull PreviewProviderId<V, C> var1, V var2, boolean var3);

    public <V, C> boolean moveToStandardPlace(@NotNull PreviewProviderId<V, C> var1, V var2);

    public <V, C> void close(@NotNull PreviewProviderId<V, C> var1, V var2);

    public static class SERVICE {
        private SERVICE() {
        }

        @Nullable
        public static PreviewManager getInstance(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/preview/PreviewManager$SERVICE", "getInstance"));
            }
            if (!UISettings.getInstance().NAVIGATE_TO_PREVIEW) {
                return null;
            }
            return (PreviewManager)ServiceManager.getService((Project)project, PreviewManager.class);
        }
    }
}

