/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectLocatorImpl
extends ProjectLocator {
    @Nullable
    public Project guessProjectForFile(VirtualFile file) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            return null;
        }
        Project[] projects = projectManager.getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        if (projects.length == 1 && !projects[0].isDisposed()) {
            return projects[0];
        }
        if (file != null) {
            for (Project project : projects) {
                if (!project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
                return project;
            }
        }
        return !projects[0].isDisposed() ? projects[0] : null;
    }

    @NotNull
    public Collection<Project> getProjectsForFile(VirtualFile file) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null || file == null) {
            List<Project> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
            }
            return list;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            List<Project> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
            }
            return list;
        }
        ArrayList<Project> result = new ArrayList<Project>(openProjects.length);
        for (Project project : openProjects) {
            if (!project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
            result.add(project);
        }
        ArrayList<Project> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
        }
        return arrayList;
    }
}

