/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;

@State(name="NewModuleRootManager", storages={@Storage(id="default", file="$MODULE_FILE$"), @Storage(id="special", storageClass=ClasspathStorage.class)}, storageChooser=StorageChooser.class)
public class ModuleRootManagerComponent
extends ModuleRootManagerImpl
implements PersistentStateComponent<ModuleRootManagerImpl.ModuleRootManagerState> {
    public ModuleRootManagerComponent(Module module, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        super(module, projectRootManager, filePointerManager);
    }

    public static class StorageChooser
    implements StateStorageChooser<ModuleRootManagerImpl> {
        public Storage[] selectStorages(Storage[] storages, ModuleRootManagerImpl moduleRootManager, StateStorageOperation operation) {
            boolean isDefaultStorageType = ClassPathStorageUtil.isDefaultStorage(moduleRootManager.getModule());
            String id = isDefaultStorageType ? "default" : "special";
            for (Storage storage : storages) {
                if (!storage.id().equals(id)) continue;
                return new Storage[]{storage};
            }
            throw new IllegalArgumentException();
        }
    }
}

