/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UpdateStrategy {
    private UserUpdateSettings myUpdateSettings;
    private int myMajorVersion;
    private BuildNumber myCurrentBuild;
    private ChannelStatus myChannelStatus;
    private UpdatesInfo myUpdatesInfo;

    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings) {
        if (currentBuild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBuild", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (updatesInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatesInfo", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        if (updateSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateSettings", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "<init>"));
        }
        this.myMajorVersion = majorVersion;
        this.myUpdatesInfo = updatesInfo;
        this.myUpdateSettings = updateSettings;
        this.myCurrentBuild = currentBuild;
        this.myChannelStatus = updateSettings.getSelectedChannelStatus();
    }

    public final CheckForUpdateResult checkForUpdates() {
        Product product = this.myUpdatesInfo.getProduct(this.myCurrentBuild.getProductCode());
        if (product == null || product.getChannels().isEmpty()) {
            return new CheckForUpdateResult(State.NOTHING_LOADED);
        }
        UpdateChannel updatedChannel = null;
        BuildInfo newBuild = null;
        List<UpdateChannel> activeChannels = this.getActiveChannels(product);
        for (UpdateChannel channel : activeChannels) {
            if (!this.hasNewVersion(channel)) continue;
            updatedChannel = channel;
            newBuild = updatedChannel.getLatestBuild();
            break;
        }
        CheckForUpdateResult result = new CheckForUpdateResult(updatedChannel, newBuild, product.getAllChannelIds());
        UpdateChannel channelToPropose = null;
        for (UpdateChannel channel : product.getChannels()) {
            if (this.myUpdateSettings.getKnownChannelsIds().contains(channel.getId()) || channel.getMajorVersion() < this.myMajorVersion || channel.getStatus().compareTo(this.myChannelStatus) < 0 || !this.hasNewVersion(channel) || channelToPropose != null && !UpdateStrategy.isBetter(channelToPropose, channel)) continue;
            channelToPropose = channel;
        }
        result.setChannelToPropose(channelToPropose);
        return result;
    }

    private static boolean isBetter(UpdateChannel channelToPropose, UpdateChannel channel) {
        return channel.getMajorVersion() > channelToPropose.getMajorVersion() || channel.getMajorVersion() == channelToPropose.getMajorVersion() && channel.getStatus().compareTo(channelToPropose.getStatus()) > 0;
    }

    private List<UpdateChannel> getActiveChannels(Product product) {
        List<UpdateChannel> channels = product.getChannels();
        ArrayList<UpdateChannel> result = new ArrayList<UpdateChannel>();
        for (UpdateChannel channel : channels) {
            if ((channel.getMajorVersion() != this.myMajorVersion || channel.getStatus().compareTo(this.myChannelStatus) < 0) && (channel.getMajorVersion() <= this.myMajorVersion || channel.getStatus() != ChannelStatus.EAP || this.myChannelStatus != ChannelStatus.EAP)) continue;
            result.add(channel);
        }
        return result;
    }

    private boolean hasNewVersion(@NotNull UpdateChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/openapi/updateSettings/impl/UpdateStrategy", "hasNewVersion"));
        }
        BuildInfo latestBuild = channel.getLatestBuild();
        if (latestBuild == null || latestBuild.getNumber() == null || this.myUpdateSettings.getIgnoredBuildNumbers().contains(latestBuild.getNumber().asStringWithoutProductCode())) {
            return false;
        }
        return this.myCurrentBuild.compareTo(latestBuild.getNumber()) < 0;
    }

    public static enum State {
        LOADED,
        CONNECTION_ERROR,
        NOTHING_LOADED;

    }
}

