/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.reporter.ConnectionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatesXmlLoader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdatesXmlLoader");
    private final String updateUrl;

    public UpdatesXmlLoader(String updatesUrl) {
        this.updateUrl = updatesUrl;
    }

    @Nullable
    public UpdatesInfo loadUpdatesInfo() throws ConnectionException {
        LOG.debug("load update xml (UPDATE_URL='" + this.updateUrl + "' )");
        if (StringUtil.isEmpty((String)this.updateUrl)) {
            LOG.debug("update url is empty: updates will not be checked");
            return null;
        }
        final Ref error = new Ref();
        FutureTask<UpdatesInfo> ft = new FutureTask<UpdatesInfo>(new Callable<UpdatesInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @Nullable
            public UpdatesInfo call() throws Exception {
                try {
                    UpdatesXmlLoader.prepareUrl(UpdatesXmlLoader.this.updateUrl);
                    URL requestUrl = UpdatesXmlLoader.this.prepareRequestUrl(UpdatesXmlLoader.this.updateUrl);
                    URLConnection connection = requestUrl.openConnection();
                    connection.setConnectTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
                    connection.setReadTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
                    InputStream inputStream = connection.getInputStream();
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    try {
                        UpdatesInfo updatesInfo = new UpdatesInfo(JDOMUtil.loadDocument((InputStream)inputStream).getRootElement());
                        return updatesInfo;
                    }
                    catch (JDOMException e) {
                        LOG.info((Throwable)e);
                        return null;
                    }
                    finally {
                        ((Reader)reader).close();
                        inputStream.close();
                    }
                }
                catch (Exception e2) {
                    error.set((Object)e2);
                }
                return null;
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(ft);
        try {
            UpdatesInfo result = ft.get(5L, TimeUnit.SECONDS);
            if (!error.isNull()) {
                throw new ConnectionException((Throwable)error.get());
            }
            return result;
        }
        catch (TimeoutException e) {
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new ConnectionException(e.getMessage(), e);
        }
        if (!ft.isDone()) {
            ft.cancel(true);
            throw new ConnectionException(IdeBundle.message((String)"updates.timeout.error", (Object[])new Object[0]));
        }
        return null;
    }

    protected static void prepareUrl(@NotNull String url) throws ConnectionException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/updateSettings/impl/UpdatesXmlLoader", "prepareUrl"));
        }
        try {
            HttpConfigurable.getInstance().prepareURL(url);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    protected URL prepareRequestUrl(@NotNull String url) throws ConnectionException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/updateSettings/impl/UpdatesXmlLoader", "prepareRequestUrl"));
        }
        try {
            if (url.startsWith("file:")) {
                return new URL(url);
            }
            return new URL(url + "?" + UpdateChecker.prepareUpdateCheckArgs());
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }
}

