/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.PlatformIcons;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class CopyRevisionNumberAction
extends DumbAwareAction {
    public CopyRevisionNumberAction() {
        super(VcsBundle.getString((String)"history.copy.revision.number"), VcsBundle.getString((String)"history.copy.revision.number"), PlatformIcons.COPY_ICON);
    }

    public void actionPerformed(AnActionEvent e) {
        VcsFileRevision fileRevision;
        VcsRevisionNumber revision = (VcsRevisionNumber)e.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revision == null && (fileRevision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        if (revision == null) {
            return;
        }
        String rev = revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(rev));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(e.getData(VcsDataKeys.VCS_FILE_REVISION) != null || e.getData(VcsDataKeys.VCS_REVISION_NUMBER) != null);
    }
}

