/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class IdePanePanel
extends JBPanel {
    public IdePanePanel(LayoutManager layout) {
        super(layout);
    }

    @Nullable
    public Icon getCenterImage() {
        return IdePanePanel.getIdeBackgroundLogo();
    }

    @Nullable
    public Icon getBackgroundImage() {
        return IdePanePanel.getIdeBackgroundImage();
    }

    public Color getBackground() {
        return IdePanePanel.getIdeBackgroundColor();
    }

    @Nullable
    public static Icon getIdeBackgroundImage() {
        return null;
    }

    @Nullable
    public static Icon getIdeBackgroundLogo() {
        String url;
        if (UIUtil.isUnderDarcula() && (url = ApplicationInfoEx.getInstanceEx().getEditorBackgroundImageUrl()) != null) {
            return IconLoader.getIcon((String)url);
        }
        return null;
    }

    protected void paintCenterImage(Graphics g) {
        Icon image = this.getCenterImage();
        if (image != null) {
            int x = (this.getWidth() - image.getIconWidth()) / 2;
            int y = ((this.getHeight() - 222) / 2 - image.getIconHeight()) / 2;
            image.paintIcon((Component)((Object)this), g, x, y);
        }
    }

    @Nullable
    public static Color getIdeBackgroundColor() {
        Color result = UIUtil.getSlightlyDarkerColor((Color)UIUtil.getPanelBackground());
        return UIUtil.isUnderDarcula() ? new Color(40, 40, 41) : UIUtil.getSlightlyDarkerColor((Color)UIUtil.getSlightlyDarkerColor((Color)result));
    }
}

