/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArchivedTemplatesFactory
extends ProjectTemplatesFactory {
    static final String ZIP = ".zip";
    private final ClearableLazyValue<MultiMap<String, Pair<URL, ClassLoader>>> myGroups = new ClearableLazyValue<MultiMap<String, Pair<URL, ClassLoader>>>(){

        @NotNull
        protected MultiMap<String, Pair<URL, ClassLoader>> compute() {
            MultiMap map = new MultiMap();
            HashMap<URL, ClassLoader> urls = new HashMap<URL, ClassLoader>();
            URL configURL = ArchivedTemplatesFactory.getCustomTemplatesURL();
            if (configURL != null) {
                urls.put(configURL, ClassLoader.getSystemClassLoader());
            }
            for (Map.Entry url : urls.entrySet()) {
                try {
                    List<String> children = UrlUtil.getChildrenRelativePaths((URL)url.getKey());
                    if (configURL == url.getKey() && !children.isEmpty()) {
                        map.putValue((Object)"User-defined", (Object)Pair.create(url.getKey(), url.getValue()));
                        continue;
                    }
                    for (String child : children) {
                        int index = child.indexOf(47);
                        if (index != -1) {
                            child = child.substring(0, index);
                        }
                        String name = child.replace('_', ' ');
                        map.putValue((Object)name, (Object)Pair.create((Object)new URL(((URL)url.getKey()).toExternalForm() + "/" + child), url.getValue()));
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            MultiMap multiMap = map;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory$1", "compute"));
            }
            return multiMap;
        }
    };
    private static final Logger LOG = Logger.getInstance(ArchivedTemplatesFactory.class);

    private static URL getCustomTemplatesURL() {
        String path = ArchivedTemplatesFactory.getCustomTemplatesPath();
        try {
            return new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static String getCustomTemplatesPath() {
        return PathManager.getConfigPath() + "/projectTemplates";
    }

    public static File getTemplateFile(String name) {
        String configURL = ArchivedTemplatesFactory.getCustomTemplatesPath();
        return new File(configURL + "/" + name + ZIP);
    }

    @Override
    @NotNull
    public String[] getGroups() {
        this.myGroups.drop();
        Set groups = ((MultiMap)this.myGroups.getValue()).keySet();
        String[] stringArray = ArrayUtil.toStringArray((Collection)groups);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "getGroups"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(String group, WizardContext context) {
        Collection urls = ((MultiMap)this.myGroups.getValue()).get((Object)group);
        ArrayList<LocalArchivedTemplate> templates = new ArrayList<LocalArchivedTemplate>();
        for (Pair url : urls) {
            try {
                List<String> children = UrlUtil.getChildrenRelativePaths((URL)url.first);
                for (String child : children) {
                    if (!child.endsWith(ZIP)) continue;
                    URL templateUrl = new URL(((URL)url.first).toExternalForm() + "/" + child);
                    templates.add(new LocalArchivedTemplate(templateUrl, (ClassLoader)url.second));
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        ProjectTemplate[] projectTemplateArray = templates.toArray(new ProjectTemplate[templates.size()]);
        if (projectTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "createTemplates"));
        }
        return projectTemplateArray;
    }

    @Override
    public int getGroupWeight(String group) {
        return "User-defined".equals(group) ? -2 : 0;
    }

    @Override
    public Icon getGroupIcon(String group) {
        return "User-defined".equals(group) ? AllIcons.Modules.Types.UserDefined : super.getGroupIcon(group);
    }
}

