/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class JavaCodeBlockModificationListener
implements PsiTreeChangePreprocessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaCodeBlockModificationListener");
    private final PsiModificationTrackerImpl myModificationTracker;

    public JavaCodeBlockModificationListener(PsiModificationTracker modificationTracker) {
        this.myModificationTracker = (PsiModificationTrackerImpl)modificationTracker;
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/JavaCodeBlockModificationListener", "treeChanged"));
        }
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: 
            case BEFORE_PROPERTY_CHANGE: 
            case BEFORE_CHILD_MOVEMENT: 
            case BEFORE_CHILD_REPLACEMENT: 
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: {
                break;
            }
            case CHILD_ADDED: 
            case CHILD_REMOVED: 
            case CHILD_REPLACED: {
                this.processChange(event.getParent(), event.getOldChild(), event.getChild());
                break;
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) break;
                this.processChange(event.getParent(), event.getParent(), null);
                break;
            }
            case CHILD_MOVED: 
            case PROPERTY_CHANGED: {
                this.myModificationTracker.incCounter();
                break;
            }
            default: {
                LOG.error("Unknown code:" + (Object)((Object)event.getCode()));
            }
        }
    }

    private void processChange(PsiElement parent, PsiElement child1, PsiElement child2) {
        try {
            if (!JavaCodeBlockModificationListener.isInsideCodeBlock(parent)) {
                if (parent != null && JavaCodeBlockModificationListener.isClassOwner((PsiElement)parent.getContainingFile()) || JavaCodeBlockModificationListener.isClassOwner(child1) || JavaCodeBlockModificationListener.isClassOwner(child2) || JavaCodeBlockModificationListener.isSourceDir(parent) || parent != null && JavaCodeBlockModificationListener.isClassOwner(parent.getParent())) {
                    this.myModificationTracker.incCounter();
                } else {
                    this.myModificationTracker.incOutOfCodeBlockModificationCounter();
                }
                return;
            }
            if (JavaCodeBlockModificationListener.containsClassesInside(child1) || child2 != child1 && JavaCodeBlockModificationListener.containsClassesInside(child2)) {
                this.myModificationTracker.incCounter();
            }
        }
        catch (PsiInvalidElementAccessException ignored) {
            this.myModificationTracker.incCounter();
        }
    }

    private static boolean isSourceDir(PsiElement element) {
        return element instanceof PsiDirectory && ProjectFileIndex.SERVICE.getInstance((Project)element.getProject()).isInSource(((PsiDirectory)element).getVirtualFile());
    }

    private static boolean isClassOwner(PsiElement element) {
        return element instanceof PsiClassOwner && !(element instanceof XmlFile) || element instanceof JspDirective;
    }

    private static boolean containsClassesInside(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiClass) {
            return true;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!JavaCodeBlockModificationListener.containsClassesInside(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInsideCodeBlock(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return false;
        }
        if (element == null || element.getParent() == null) {
            return true;
        }
        PsiElement parent = element;
        while (!(parent instanceof PsiFile) && !(parent instanceof PsiDirectory) && parent != null) {
            if (parent instanceof PsiClass) {
                return false;
            }
            if (parent instanceof PsiModifiableCodeBlock && !((PsiModifiableCodeBlock)parent).shouldChangeModificationCount(element)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

