/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.idCache;

import com.intellij.lexer.Lexer;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class JavaFilterLexer
extends BaseFilterLexer {
    private static final TokenSet ourSkipWordsScanSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, JavaTokenType.LPARENTH, JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.RBRACE, JavaTokenType.LBRACKET, JavaTokenType.RBRACKET, JavaTokenType.SEMICOLON, JavaTokenType.COMMA, JavaTokenType.DOT, JavaTokenType.ELLIPSIS, JavaTokenType.AT}), ElementType.OPERATION_BIT_SET});

    public JavaFilterLexer(Lexer originalLexer, OccurrenceConsumer table) {
        super(originalLexer, table);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.LONG_LITERAL || tokenType == JavaTokenType.INTEGER_LITERAL || tokenType == JavaTokenType.CHARACTER_LITERAL) {
            this.addOccurrenceInToken(1);
        } else if (tokenType == JavaTokenType.STRING_LITERAL) {
            this.scanWordsInToken(12, false, true);
        } else if (ElementType.JAVA_COMMENT_BIT_SET.contains(tokenType)) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        } else if (!ourSkipWordsScanSet.contains(tokenType)) {
            this.scanWordsInToken(16, false, false);
        }
        this.myDelegate.advance();
    }
}

