/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.SharedImplUtil");
    private static final boolean CHECK_FOR_READ_ACTION = DebugUtil.DO_EXPENSIVE_CHECKS || ApplicationManager.getApplication().isInternal();

    private SharedImplUtil() {
    }

    public static PsiElement getParent(ASTNode thisElement) {
        if (CHECK_FOR_READ_ACTION) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeParent());
    }

    public static PsiElement getFirstChild(ASTNode element) {
        return SourceTreeToPsiMap.treeElementToPsi(element.getFirstChildNode());
    }

    @Nullable
    public static PsiElement getLastChild(ASTNode element) {
        return SourceTreeToPsiMap.treeElementToPsi(element.getLastChildNode());
    }

    public static PsiElement getNextSibling(ASTNode thisElement) {
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeNext());
    }

    public static PsiElement getPrevSibling(ASTNode thisElement) {
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreePrev());
    }

    public static PsiFile getContainingFile(ASTNode thisElement) {
        PsiElement psiElement;
        FileElement element = SharedImplUtil.findFileElement(thisElement);
        PsiElement psiElement2 = psiElement = element == null ? null : element.getPsi();
        if (psiElement == null) {
            return null;
        }
        return psiElement.getContainingFile();
    }

    public static boolean isValid(ASTNode thisElement) {
        LOG.assertTrue(thisElement instanceof PsiElement);
        PsiFile file = SharedImplUtil.getContainingFile(thisElement);
        return file != null && file.isValid();
    }

    public static boolean isWritable(ASTNode thisElement) {
        PsiFile file = SharedImplUtil.getContainingFile(thisElement);
        return file == null || file.isWritable();
    }

    public static FileElement findFileElement(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/SharedImplUtil", "findFileElement"));
        }
        if (CHECK_FOR_READ_ACTION) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            element = parent;
        }
        if (element instanceof FileElement) {
            return (FileElement)element;
        }
        return null;
    }

    public static CharTable findCharTableByTree(ASTNode tree) {
        while (tree != null) {
            CharTable userData = (CharTable)tree.getUserData(CharTable.CHAR_TABLE_KEY);
            if (userData != null) {
                return userData;
            }
            if (tree instanceof FileElement) {
                return ((FileElement)tree).getCharTable();
            }
            tree = tree.getTreeParent();
        }
        LOG.error("Invalid root element");
        return null;
    }

    public static PsiElement addRange(PsiElement thisElement, PsiElement first, PsiElement last, ASTNode anchor, Boolean before) throws IncorrectOperationException {
        ASTNode element;
        CheckUtil.checkWritable(thisElement);
        CharTable table = SharedImplUtil.findCharTableByTree(SourceTreeToPsiMap.psiElementToTree(thisElement));
        TreeElement copyFirst = null;
        TreeElement copyLast = null;
        ASTNode next = SourceTreeToPsiMap.psiElementToTree(last).getTreeNext();
        CompositeElement parent = null;
        for (element = SourceTreeToPsiMap.psiElementToTree(first); element != next; element = element.getTreeNext()) {
            TreeElement elementCopy = ChangeUtil.copyElement((TreeElement)element, table);
            if (element == first.getNode()) {
                copyFirst = elementCopy;
            }
            if (element == last.getNode()) {
                copyLast = elementCopy;
            }
            if (parent == null) {
                parent = elementCopy.getTreeParent();
                continue;
            }
            if (elementCopy.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.setNodeGenerated(elementCopy, true);
            }
            parent.addChild(elementCopy, null);
        }
        if (copyFirst == null) {
            return null;
        }
        copyFirst = ((CompositeElement)SourceTreeToPsiMap.psiElementToTree(thisElement)).addInternal(copyFirst, copyLast, anchor, before);
        for (element = copyFirst; element != null; element = element.getTreeNext()) {
            if ((element = ChangeUtil.decodeInformation((TreeElement)element)).getTreePrev() != null) continue;
            copyFirst = element;
        }
        return SourceTreeToPsiMap.treeElementToPsi(copyFirst);
    }

    public static PsiManager getManagerByTree(ASTNode node) {
        if (node instanceof FileElement) {
            return node.getPsi().getManager();
        }
        return node.getTreeParent().getPsi().getManager();
    }

    public static ASTNode[] getChildrenOfType(ASTNode node, IElementType elementType) {
        int count = SharedImplUtil.countChildrenOfType(node, elementType);
        if (count == 0) {
            return ASTNode.EMPTY_ARRAY;
        }
        ASTNode[] result = new ASTNode[count];
        count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            result[count++] = child;
        }
        return result;
    }

    private static int countChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/SharedImplUtil", "countChildrenOfType"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/tree/SharedImplUtil", "countChildrenOfType"));
        }
        int count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            ++count;
        }
        return count;
    }

    public static void acceptChildren(PsiElementVisitor visitor, CompositeElement root) {
        for (TreeElement childNode = root.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            PsiElement psi = childNode instanceof PsiElement ? (PsiElement)childNode : childNode.getPsi();
            psi.accept(visitor);
        }
    }

    public static PsiElement doReplace(PsiElement psiElement, TreeElement treeElement, PsiElement newElement) {
        CompositeElement treeParent = treeElement.getTreeParent();
        LOG.assertTrue(treeParent != null);
        CheckUtil.checkWritable(psiElement);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        treeParent.replaceChildInternal(treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        PsiElement result = SourceTreeToPsiMap.treeElementToPsi(elementCopy);
        treeElement.invalidate();
        return result;
    }
}

