/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;

public class TypeConversionDescriptor
extends TypeConversionDescriptorBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + TypeConversionDescriptor.class.getName()));
    private String myStringToReplace = null;
    private String myReplaceByString = "$";
    private PsiExpression myExpression;

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        this.myStringToReplace = stringToReplace;
        this.myReplaceByString = replaceByString;
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiExpression expression) {
        this.myStringToReplace = stringToReplace;
        this.myReplaceByString = replaceByString;
        this.myExpression = expression;
    }

    public void setStringToReplace(String stringToReplace) {
        this.myStringToReplace = stringToReplace;
    }

    public void setReplaceByString(String replaceByString) {
        this.myReplaceByString = replaceByString;
    }

    public String getStringToReplace() {
        return this.myStringToReplace;
    }

    public String getReplaceByString() {
        return this.myReplaceByString;
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    public void setExpression(PsiExpression expression) {
        this.myExpression = expression;
    }

    @Override
    public void replace(PsiExpression expression) {
        if (this.getExpression() != null) {
            expression = this.getExpression();
        }
        Project project = expression.getProject();
        ReplaceOptions options = new ReplaceOptions();
        options.setMatchOptions(new MatchOptions());
        Replacer replacer = new Replacer(project, null);
        try {
            String replacement = replacer.testReplace(expression.getText(), this.getStringToReplace(), this.getReplaceByString(), options);
            try {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(expression.replace((PsiElement)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText(replacement, (PsiElement)expression)));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.myReplaceByString != null) {
            buf.append(this.myReplaceByString);
        }
        if (this.myStringToReplace != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.myStringToReplace);
        }
        if (this.myExpression != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.myExpression.getText());
        }
        return buf.toString();
    }
}

