/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;

public class StructuralReplaceAction
extends AnAction {
    public void actionPerformed(AnActionEvent event) {
        StructuralReplaceAction.triggerAction(null, SearchContext.buildFromDataContext(event.getDataContext()));
    }

    public static void triggerAction(Configuration config, SearchContext searchContext) {
        ReplaceDialog replaceDialog = new ReplaceDialog(searchContext);
        if (config != null) {
            replaceDialog.setUseLastConfiguration(true);
            replaceDialog.setValuesFromConfig(config);
        }
        replaceDialog.show();
    }

    public void update(AnActionEvent event) {
        StructuralSearchPlugin plugin;
        Presentation presentation = event.getPresentation();
        DataContext context = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        StructuralSearchPlugin structuralSearchPlugin = plugin = project == null ? null : StructuralSearchPlugin.getInstance(project);
        if (plugin == null || plugin.isSearchInProgress() || plugin.isReplaceInProgress() || plugin.isDialogVisible()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
        super.update(event);
    }
}

