/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorTextFieldCellRenderer
implements TableCellRenderer,
Disposable {
    private static final Key<MyPanel> MY_PANEL_PROPERTY = Key.create((String)"EditorTextFieldCellRenderer.MyEditorPanel");

    public EditorTextFieldCellRenderer(Disposable parent) {
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected abstract EditorColorsScheme getColorScheme();

    protected abstract String getText(FontMetrics var1, JTable var2, Object var3, int var4, int var5);

    protected void customizeEditor(EditorEx editor, Object value, boolean selected, int row, int col) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Font editorFont;
        MyPanel panel = this.getEditorPanel(table);
        EditorEx editor = panel.myEditor;
        Font font = table.getFont();
        if (!Comparing.equal((Object)font, (Object)(editorFont = editor.getColorsScheme().getFont(EditorFontType.PLAIN)))) {
            editor.getColorsScheme().setEditorFontSize(font.getSize());
        }
        panel.setText(this.getText(((EditorImpl)editor).getFontMetrics(0), table, value, row, column));
        ((EditorImpl)editor).setPaintSelection(isSelected);
        editor.getSelectionModel().setSelection(0, isSelected ? editor.getDocument().getTextLength() : 0);
        editor.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, table.getSelectionBackground());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, table.getSelectionForeground());
        editor.setBackgroundColor(EditorTextFieldCellRenderer.getCellBackgroundColor(this.getColorScheme(), table, isSelected, row));
        panel.setBorder(null);
        this.customizeEditor(editor, value, isSelected, row, column);
        return panel;
    }

    public static Color getCellBackgroundColor(EditorColorsScheme colorsScheme, JTable table, boolean isSelected, int row) {
        return isSelected ? table.getSelectionBackground() : (table.getSelectionModel().getLeadSelectionIndex() == row ? colorsScheme.getColor(EditorColors.CARET_ROW_COLOR) : table.getBackground());
    }

    @NotNull
    private MyPanel getEditorPanel(JTable table) {
        MyPanel panel = (MyPanel)UIUtil.getClientProperty((JComponent)table, MY_PANEL_PROPERTY);
        if (panel != null) {
            EditorColorsScheme scheme = panel.myEditor.getColorsScheme();
            if (scheme instanceof DelegateColorScheme) {
                ((DelegateColorScheme)scheme).setDelegate(this.getColorScheme());
            }
            MyPanel myPanel = panel;
            if (myPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer", "getEditorPanel"));
            }
            return myPanel;
        }
        EditorTextField field = new EditorTextField(new MyDocument(), null, (FileType)FileTypes.PLAIN_TEXT);
        field.setSupplementary(true);
        field.addNotify();
        EditorEx editor = (EditorEx)ObjectUtils.assertNotNull((Object)field.getEditor());
        editor.setRendererMode(true);
        editor.setColorsScheme(editor.createBoundColorSchemeDelegate(null));
        editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, null);
        editor.getScrollPane().setBorder(null);
        panel = new MyPanel(editor);
        Disposer.register((Disposable)this, (Disposable)panel);
        table.putClientProperty(MY_PANEL_PROPERTY, panel);
        MyPanel myPanel = panel;
        if (myPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer", "getEditorPanel"));
        }
        return myPanel;
    }

    public void dispose() {
    }

    private static class MyDocument
    extends UserDataHolderBase
    implements DocumentEx {
        RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree<RangeMarkerEx>((Document)this){};
        LineSet myLineSet = new LineSet();
        char[] myChars = ArrayUtil.EMPTY_CHAR_ARRAY;
        String myString = "";

        private MyDocument() {
        }

        public void setText(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "setText"));
            }
            String s = StringUtil.convertLineSeparators((String)((Object)text).toString());
            this.myChars = new char[s.length()];
            s.getChars(0, s.length(), this.myChars, 0);
            this.myString = new String(this.myChars);
            this.myLineSet.documentCreated(this);
        }

        @Override
        public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        }

        @Override
        @NotNull
        public LineIterator createLineIterator() {
            LineIterator lineIterator = this.myLineSet.createIterator();
            if (lineIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createLineIterator"));
            }
            return lineIterator;
        }

        @Override
        public void setModificationStamp(long modificationStamp) {
        }

        @Override
        public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addEditReadOnlyListener"));
            }
        }

        @Override
        public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeEditReadOnlyListener"));
            }
        }

        @Override
        public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "replaceText"));
            }
        }

        @Override
        public void moveText(int srcStart, int srcEnd, int dstOffset) {
        }

        @Override
        public int getListenersCount() {
            return 0;
        }

        @Override
        public void suppressGuardedExceptions() {
        }

        @Override
        public void unSuppressGuardedExceptions() {
        }

        @Override
        public boolean isInEventsHandling() {
            return false;
        }

        @Override
        public void clearLineModificationFlags() {
        }

        @Override
        public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeRangeMarker"));
            }
            return this.myRangeMarkers.removeInterval(rangeMarker);
        }

        @Override
        public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
            if (rangeMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "registerRangeMarker"));
            }
            this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
        }

        @Override
        public boolean isInBulkUpdate() {
            return false;
        }

        @Override
        public void setInBulkUpdate(boolean value) {
        }

        @Override
        @NotNull
        public List<RangeMarker> getGuardedBlocks() {
            List<RangeMarker> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getGuardedBlocks"));
            }
            return list;
        }

        @Override
        public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "processRangeMarkers"));
            }
            return this.myRangeMarkers.process(processor);
        }

        @Override
        public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "processRangeMarkersOverlappingWith"));
            }
            return this.myRangeMarkers.processOverlappingWith(start, end, processor);
        }

        @NotNull
        public String getText() {
            String string = this.myString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getText"));
            }
            return string;
        }

        @NotNull
        public String getText(@NotNull TextRange range) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getText"));
            }
            String string = range.substring(this.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getText"));
            }
            return string;
        }

        @NotNull
        public CharSequence getCharsSequence() {
            String string = this.myString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getCharsSequence"));
            }
            return string;
        }

        @NotNull
        public CharSequence getImmutableCharSequence() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getImmutableCharSequence"));
            }
            return string;
        }

        @NotNull
        public char[] getChars() {
            if (this.myChars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "getChars"));
            }
            return this.myChars;
        }

        public int getTextLength() {
            return this.myChars.length;
        }

        public int getLineCount() {
            return this.myLineSet.findLineIndex(this.myChars.length) + 1;
        }

        public int getLineNumber(int offset) {
            return this.myLineSet.findLineIndex(offset);
        }

        public int getLineStartOffset(int line) {
            return this.myChars.length == 0 ? 0 : this.myLineSet.getLineStart(line);
        }

        public int getLineEndOffset(int line) {
            return this.myChars.length == 0 ? 0 : this.myLineSet.getLineEnd(line);
        }

        public void insertString(int offset, @NotNull CharSequence s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "insertString"));
            }
        }

        public void deleteString(int startOffset, int endOffset) {
        }

        public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "replaceString"));
            }
        }

        public boolean isWritable() {
            return false;
        }

        public long getModificationStamp() {
            return 0L;
        }

        public void fireReadOnlyModificationAttempt() {
        }

        public void addDocumentListener(@NotNull DocumentListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addDocumentListener"));
            }
        }

        public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addDocumentListener"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addDocumentListener"));
            }
        }

        public void removeDocumentListener(@NotNull DocumentListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeDocumentListener"));
            }
        }

        @NotNull
        public RangeMarker createRangeMarker(int startOffset, int endOffset) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            return null;
        }

        @NotNull
        public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            return null;
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "addPropertyChangeListener"));
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removePropertyChangeListener"));
            }
        }

        public void setReadOnly(boolean isReadOnly) {
        }

        @NotNull
        public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createGuardedBlock"));
            }
            return null;
        }

        public void removeGuardedBlock(@NotNull RangeMarker block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "removeGuardedBlock"));
            }
        }

        @Nullable
        public RangeMarker getOffsetGuard(int offset) {
            return null;
        }

        @Nullable
        public RangeMarker getRangeGuard(int start, int end) {
            return null;
        }

        public void startGuardedBlockChecking() {
        }

        public void stopGuardedBlockChecking() {
        }

        public void setCyclicBufferSize(int bufferSize) {
        }

        @NotNull
        public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument", "createRangeMarker"));
            }
            return null;
        }

        public int getLineSeparatorLength(int line) {
            return 0;
        }
    }

    private static class MyPanel
    extends CellRendererPanel
    implements Disposable {
        private static final String ABBREVIATION_SUFFIX = "\u2026";
        private static final char RETURN_SYMBOL = '\u23ce';
        private final StringBuilder myDocumentTextBuilder = new StringBuilder();
        private final EditorEx myEditor;
        private Dimension myPreferredSize;

        public MyPanel(EditorEx editor) {
            this.add(editor.getContentComponent());
            this.myEditor = editor;
        }

        public void setText(String text) {
            this.setText(text, false);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myPreferredSize == null ? super.getPreferredSize() : this.myPreferredSize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.getBorder() == null) {
                return;
            }
            Color oldColor = g.getColor();
            Rectangle clip = g.getClipBounds();
            g.setColor(this.myEditor.getBackgroundColor());
            Insets insets = this.getInsets();
            g.fillRect(0, 0, insets.left, clip.height);
            g.fillRect(clip.width - insets.left - insets.right, 0, clip.width, clip.height);
            g.setColor(oldColor);
        }

        @Override
        protected void paintChildren(Graphics g) {
            this.updateText();
            super.paintChildren(g);
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }

        private void updateText() {
            FontMetrics fontMetrics = ((EditorImpl)this.myEditor).getFontMetrics(0);
            DocumentEx document = this.myEditor.getDocument();
            Insets insets = this.getInsets();
            int maxLineWidth = this.getWidth() - (insets != null ? insets.left + insets.right : 0);
            this.myDocumentTextBuilder.setLength(0);
            if ((float)(this.getHeight() / this.myEditor.getLineHeight()) < 1.1f) {
                String line = document.getText().replace('\n', '\u23ce');
                MyPanel.appendAbbreviatedLine(this.myDocumentTextBuilder, line, fontMetrics, maxLineWidth);
            } else {
                LineIterator line = document.createLineIterator();
                while (!line.atEnd()) {
                    String lineText = document.getText(new TextRange(line.getStart(), line.getEnd()));
                    MyPanel.appendAbbreviatedLine(this.myDocumentTextBuilder, lineText, fontMetrics, maxLineWidth);
                    line.advance();
                }
            }
            this.setText(this.myDocumentTextBuilder.toString(), true);
        }

        private static void appendAbbreviatedLine(StringBuilder to, String line, FontMetrics metrics, int maxWidth) {
            int nextCharWidth;
            int abbrIdx;
            if (metrics.charWidth('m') * line.length() <= maxWidth) {
                to.append(line);
                return;
            }
            int abbrWidth = metrics.stringWidth(ABBREVIATION_SUFFIX);
            for (abbrIdx = 0; abbrIdx < line.length() && abbrWidth + (nextCharWidth = metrics.charWidth(line.charAt(abbrIdx))) < maxWidth; ++abbrIdx) {
                abbrWidth += nextCharWidth;
            }
            to.append(line, 0, abbrIdx);
            to.append(ABBREVIATION_SUFFIX);
            if (abbrIdx != line.length() && line.endsWith("\n")) {
                to.append('\n');
            }
        }

        private void setText(String text, boolean abbreviationOfCurrentText) {
            if (!abbreviationOfCurrentText) {
                this.myEditor.getMarkupModel().removeAllHighlighters();
            }
            this.myEditor.getDocument().setText(text);
            this.myEditor.getHighlighter().setText((CharSequence)text);
            ((EditorImpl)this.myEditor).resetSizes();
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            selectionModel.setSelection(0, selectionModel.hasSelection() ? this.myEditor.getDocument().getTextLength() : 0);
            if (!abbreviationOfCurrentText) {
                this.myPreferredSize = super.getPreferredSize();
            }
        }
    }
}

