/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.GotItPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotItMessage {
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myMessage;
    private Disposable myDisposable;
    private Runnable myCallback;
    private HyperlinkListener myHyperlinkListener;
    private boolean myShowCallout;

    private GotItMessage(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ui/GotItMessage", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/ui/GotItMessage", "<init>"));
        }
        this.myHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
        this.myShowCallout = true;
        this.myTitle = title;
        this.myMessage = "<html><body><div align='center' style='font-family: " + UIUtil.getLabelFont().getFontName() + "; font-size: 12pt;'>" + StringUtil.replace((String)message, (String)"\n", (String)"<br>") + "</div></body></html>";
    }

    public static GotItMessage createMessage(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ui/GotItMessage", "createMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/ui/GotItMessage", "createMessage"));
        }
        return new GotItMessage(title, message);
    }

    public GotItMessage setDisposable(Disposable disposable) {
        this.myDisposable = disposable;
        return this;
    }

    public GotItMessage setCallback(@Nullable Runnable callback) {
        this.myCallback = callback;
        return this;
    }

    public GotItMessage setHyperlinkListener(@Nullable HyperlinkListener hyperlinkListener) {
        this.myHyperlinkListener = hyperlinkListener;
        return this;
    }

    public GotItMessage setShowCallout(boolean showCallout) {
        this.myShowCallout = showCallout;
        return this;
    }

    public void show(RelativePoint point, Balloon.Position position) {
        GotItPanel panel = new GotItPanel();
        panel.myTitle.setText(this.myTitle);
        panel.myMessage.setText(this.myMessage);
        if (this.myHyperlinkListener != null) {
            panel.myMessage.addHyperlinkListener(this.myHyperlinkListener);
        }
        panel.myButton.setCursor(Cursor.getPredefinedCursor(12));
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel.myRoot);
        if (this.myDisposable != null) {
            builder.setDisposable(this.myDisposable);
        }
        final Balloon balloon = builder.setFillColor(UIUtil.getListBackground()).setHideOnClickOutside(false).setHideOnAction(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setShowCallout(this.myShowCallout).setBlockClicksThroughBalloon(true).createBalloon();
        panel.myButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                balloon.hide();
                if (GotItMessage.this.myCallback != null) {
                    GotItMessage.this.myCallback.run();
                }
            }
        });
        balloon.show(point, position);
    }
}

