/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;

public class MessageBusUtil {
    public static <T> void runOnSyncPublisher(Project project, Topic<T> topic, Consumer<T> listener) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable = MessageBusUtil.createPublisherRunnable(project, topic, listener);
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            application.runReadAction(runnable);
        }
    }

    private static <T> Runnable createPublisherRunnable(final Project project, final Topic<T> topic, final Consumer<T> listener) {
        return new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                listener.consume(project.getMessageBus().syncPublisher(topic));
            }
        };
    }

    public static <T> void invokeLaterIfNeededOnSyncPublisher(Project project, Topic<T> topic, Consumer<T> listener) {
        Application application = ApplicationManager.getApplication();
        Runnable runnable = MessageBusUtil.createPublisherRunnable(project, topic, listener);
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable);
        }
    }
}

