/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.awt.EventQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsCommitCache<T extends VcsShortCommitDetails> {
    private final SLRUMap<Hash, T> myCache = new SLRUMap(5000, 5000);

    VcsCommitCache() {
    }

    public void put(@NotNull Hash hash, @NotNull T commit) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "put"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VcsCommitCache", "put"));
        }
        assert (EventQueue.isDispatchThread());
        this.myCache.put((Object)hash, commit);
    }

    public boolean isKeyCached(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "isKeyCached"));
        }
        assert (EventQueue.isDispatchThread());
        return this.myCache.get((Object)hash) != null;
    }

    @Nullable
    public T get(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "get"));
        }
        assert (EventQueue.isDispatchThread());
        return (T)((VcsShortCommitDetails)this.myCache.get((Object)hash));
    }

    public void remove(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsCommitCache", "remove"));
        }
        this.myCache.remove((Object)hash);
    }
}

