/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitCountStage;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogHashMap;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisiblePackBuilder {
    private static final Logger LOG = Logger.getInstance(VisiblePackBuilder.class);
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final Map<Hash, VcsCommitMetadata> myTopCommitsDetailsCache;
    @NotNull
    private final CommitDetailsGetter myCommitDetailsGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;

    VisiblePackBuilder(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogHashMap hashMap, @NotNull Map<Hash, VcsCommitMetadata> topCommitsDetailsCache, @NotNull CommitDetailsGetter detailsGetter) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (topCommitsDetailsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topCommitsDetailsCache", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (detailsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsGetter", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        this.myHashMap = hashMap;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
    }

    @NotNull
    Pair<VisiblePack, CommitCountStage> build(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        boolean canRequestMore;
        Condition<Integer> filter;
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (commitCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitCount", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        VcsLogHashFilter hashFilter = filters.getHashFilter();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            Pair pair = Pair.create((Object)this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType), (Object)((Object)commitCount));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
            }
            return pair;
        }
        List detailsFilters = filters.getDetailsFilters();
        if (!detailsFilters.isEmpty()) {
            List<Object> matchingCommits = null;
            if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.filterInMemory(dataPack.getPermanentGraph(), detailsFilters)).size() < commitCount.getCount()) {
                commitCount = commitCount.next();
                matchingCommits = null;
            }
            if (matchingCommits == null) {
                try {
                    matchingCommits = VisiblePackBuilder.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount());
                }
                catch (VcsException e) {
                    matchingCommits = Collections.emptyList();
                    LOG.error((Throwable)e);
                }
            }
            filter = this.getFilterFromCommits(matchingCommits);
            canRequestMore = matchingCommits.size() >= commitCount.getCount();
        } else {
            filter = null;
            canRequestMore = false;
        }
        Set<Integer> heads = this.getMatchingHeads(dataPack.getRefs(), filters);
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, heads, filter);
        Pair pair = Pair.create((Object)new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, canRequestMore), (Object)((Object)commitCount));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        return pair;
    }

    private VisiblePack applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        final Set indices = ContainerUtil.map2SetNotNull(hashes, (Function)new Function<String, Integer>(){

            public Integer fun(String partOfHash) {
                Hash hash = VisiblePackBuilder.this.myHashMap.findHashByString(partOfHash);
                return hash != null ? Integer.valueOf(VisiblePackBuilder.this.myHashMap.getCommitIndex(hash)) : null;
            }
        });
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, (Condition)new Condition<Integer>(){

            public boolean value(Integer integer) {
                return indices.contains(integer);
            }
        });
        return new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false);
    }

    @Nullable
    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull VcsLogFilterCollection filters) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        VcsLogBranchFilter branchFilter = filters.getBranchFilter();
        if (branchFilter == null) {
            return null;
        }
        HashSet branchNames = new HashSet(branchFilter.getBranchNames());
        return new HashSet((Collection)ContainerUtil.mapNotNull((Collection)refs.getBranches(), (Function)new Function<VcsRef, Integer>((Collection)branchNames){
            final /* synthetic */ Collection val$branchNames;
            {
                this.val$branchNames = collection;
            }

            public Integer fun(VcsRef ref) {
                if (this.val$branchNames.contains(ref.getName())) {
                    return VisiblePackBuilder.this.myHashMap.getCommitIndex(ref.getCommitHash());
                }
                return null;
            }
        }));
    }

    @NotNull
    private List<Hash> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters) {
        GraphCommit commit;
        VcsCommitMetadata data;
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        Iterator i$ = permanentGraph.getAllCommits().iterator();
        while (i$.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)i$.next()).getId())) != null) {
            if (!VisiblePackBuilder.matchesAllFilters(data, detailsFilters)) continue;
            result.add(data.getId());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        return arrayList;
    }

    private static boolean matchesAllFilters(final @NotNull VcsCommitMetadata commit, @NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        return ContainerUtil.and(detailsFilters, (Condition)new Condition<VcsLogDetailsFilter>(){

            public boolean value(VcsLogDetailsFilter filter) {
                return filter.matches(commit);
            }
        });
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        final Hash hash = this.myHashMap.getHash(commitIndex);
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(hash);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<VcsCommitMetadata>(){

            public VcsCommitMetadata compute() {
                return (VcsCommitMetadata)VisiblePackBuilder.this.myCommitDetailsGetter.getCommitDataIfAvailable(hash);
            }
        });
    }

    @NotNull
    private static List<Hash> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        ArrayList logs = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            if (filterCollection.getStructureFilter() != null && filterCollection.getStructureFilter().getFiles(root).isEmpty() || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUserNames(root).isEmpty()) continue;
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, filterCollection, maxCount);
            logs.add(matchingCommits);
        }
        List compoundLog = new VcsLogMultiRepoJoiner().join(logs);
        List list = ContainerUtil.map(compoundLog, (Function)new Function<TimedVcsCommit, Hash>(){

            public Hash fun(TimedVcsCommit commit) {
                return (Hash)commit.getId();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        return list;
    }

    @Nullable
    private Condition<Integer> getFilterFromCommits(@Nullable List<Hash> filteredCommits) {
        if (filteredCommits == null) {
            return null;
        }
        final Set commitSet = ContainerUtil.map2Set(filteredCommits, (Function)new Function<Hash, Integer>(){

            public Integer fun(Hash hash) {
                return VisiblePackBuilder.this.myHashMap.getCommitIndex(hash);
            }
        });
        return new Condition<Integer>(){

            public boolean value(Integer integer) {
                return commitSet.contains(integer);
            }
        };
    }
}

