/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter extends VcsLogFilter>
extends FilterPopupComponent<Filter> {
    private static final int MAX_FILTER_VALUE_LENGTH = 30;
    @Nullable
    private Collection<String> mySelectedValues;

    MultipleValueFilterPopupComponent(@NotNull VcsLogClassicFilterUi filterUi, @NotNull String filterName) {
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "<init>"));
        }
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "<init>"));
        }
        super(filterUi, filterName);
    }

    @NotNull
    protected abstract List<List<String>> getRecentValuesFromSettings();

    protected abstract void rememberValuesInSettings(@NotNull Collection<String> var1);

    @NotNull
    protected abstract List<String> getAllValues();

    @Nullable
    protected Collection<String> getSelectedValues() {
        return this.mySelectedValues;
    }

    @NotNull
    protected ActionGroup createRecentItemsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        List<List<String>> recentlyFilteredUsers = this.getRecentValuesFromSettings();
        if (!recentlyFilteredUsers.isEmpty()) {
            group.addSeparator("Recent");
            for (List<String> recentGroup : recentlyFilteredUsers) {
                group.add((AnAction)new PredefinedValueAction(recentGroup));
            }
            group.addSeparator();
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createRecentItemsActionGroup"));
        }
        return defaultActionGroup;
    }

    void apply(@Nullable Collection<String> values, @NotNull String text, @NotNull String tooltip) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "apply"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "apply"));
        }
        this.mySelectedValues = values;
        this.applyFilters();
        this.setValue(text, tooltip);
        if (values != null) {
            this.rememberValuesInSettings(values);
        }
    }

    @NotNull
    static String displayableText(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "displayableText"));
        }
        if (values.size() == 1) {
            String string = values.iterator().next();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "displayableText"));
            }
            return string;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)StringUtil.join(values, (String)"|"), (int)30, (int)0, (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "displayableText"));
        }
        return string;
    }

    @NotNull
    static String tooltip(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "tooltip"));
        }
        String string = StringUtil.join(values, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "tooltip"));
        }
        return string;
    }

    @Override
    @NotNull
    protected AnAction createAllAction() {
        DumbAwareAction dumbAwareAction = new DumbAwareAction("All"){

            public void actionPerformed(AnActionEvent e) {
                MultipleValueFilterPopupComponent.this.apply(null, "All", "All");
            }
        };
        if (dumbAwareAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createAllAction"));
        }
        return dumbAwareAction;
    }

    @NotNull
    protected AnAction createPredefinedValueAction(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createPredefinedValueAction"));
        }
        PredefinedValueAction predefinedValueAction = new PredefinedValueAction(values);
        if (predefinedValueAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createPredefinedValueAction"));
        }
        return predefinedValueAction;
    }

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        SelectMultipleValuesAction selectMultipleValuesAction = new SelectMultipleValuesAction();
        if (selectMultipleValuesAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent", "createSelectMultipleValuesAction"));
        }
        return selectMultipleValuesAction;
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super("Select...");
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project, this.myVariants, this.getPopupText(MultipleValueFilterPopupComponent.this.mySelectedValues));
            JBPopup popup = popupBuilder.createPopup();
            popup.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (event.isOk()) {
                        Collection<String> selectedValues = popupBuilder.getSelectedValues();
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.apply(null, "All", "All");
                        } else {
                            MultipleValueFilterPopupComponent.this.apply(selectedValues, MultipleValueFilterPopupComponent.displayableText(selectedValues), MultipleValueFilterPopupComponent.tooltip(selectedValues));
                        }
                    }
                }
            });
            popup.showUnderneathOf((Component)MultipleValueFilterPopupComponent.this);
        }

        @NotNull
        private String getPopupText(@Nullable Collection<String> selectedValues) {
            String string = selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$SelectMultipleValuesAction", "getPopupText"));
            }
            return string;
        }
    }

    private class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myValues;

        public PredefinedValueAction(Collection<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultipleValueFilterPopupComponent$PredefinedValueAction", "<init>"));
            }
            super(MultipleValueFilterPopupComponent.displayableText(values), MultipleValueFilterPopupComponent.tooltip(values), null);
            this.myValues = values;
        }

        public void actionPerformed(AnActionEvent e) {
            MultipleValueFilterPopupComponent.this.apply(this.myValues, MultipleValueFilterPopupComponent.displayableText(this.myValues), MultipleValueFilterPopupComponent.tooltip(this.myValues));
        }
    }
}

