/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.RefPainter;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)"Vcs.Log");
    private static final String STANDARD_LAYER = "Standard";
    private static final String MESSAGE_LAYER = "Message";
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final RefsPanel myRefsPanel;
    @NotNull
    private final DataPanel myDataPanel;
    @NotNull
    private final ContainingBranchesPanel myContainingBranchesPanel;
    @NotNull
    private final MessagePanel myMessagePanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private VisiblePack myDataPack;

    DetailsPanel(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogGraphTable graphTable, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePack initialDataPack) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        super(new CardLayout());
        this.myLogDataHolder = logDataHolder;
        this.myGraphTable = graphTable;
        this.myDataPack = initialDataPack;
        this.myRefsPanel = new RefsPanel(colorManager);
        this.myDataPanel = new DataPanel(logDataHolder.getProject());
        this.myContainingBranchesPanel = new ContainingBranchesPanel();
        this.myMessagePanel = new MessagePanel();
        final JScrollPane scrollPane = ScrollPaneFactory.createScrollPane();
        JPanel content = new JPanel((LayoutManager)new MigLayout("flowy, ins 0, fill, hidemode 3")){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = scrollPane.getViewport().getWidth() - 5;
                return size;
            }
        };
        content.setOpaque(false);
        scrollPane.setViewportView(content);
        content.add((Component)this.myRefsPanel, "shrinky, pushx, growx");
        content.add((Component)this.myDataPanel, "growy, push");
        content.add((Component)this.myContainingBranchesPanel, "shrinky, pushx, growx");
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)logDataHolder, 300);
        this.myLoadingPanel.add((Component)scrollPane);
        this.add((Component)this.myLoadingPanel, STANDARD_LAYER);
        this.add((Component)this.myMessagePanel, MESSAGE_LAYER);
        this.setBackground(UIUtil.getTableBackground());
        this.showMessage("No commits selected");
    }

    void updateDataPack(@NotNull VisiblePack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent notUsed) {
        int[] rows = this.myGraphTable.getSelectedRows();
        if (rows.length < 1) {
            this.showMessage("No commits selected");
        } else if (rows.length > 1) {
            this.showMessage("Several commits selected");
        } else {
            ((CardLayout)this.getLayout()).show(this, STANDARD_LAYER);
            int row = rows[0];
            GraphTableModel tableModel = (GraphTableModel)this.myGraphTable.getModel();
            Hash hash = tableModel.getHashAtRow(row);
            VcsFullCommitDetails commitData = (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(row, tableModel);
            if (commitData == null || hash == null) {
                this.showMessage("No commits selected");
                return;
            }
            if (commitData instanceof LoadingDetails) {
                this.myLoadingPanel.startLoading();
                this.myDataPanel.setData(null);
                this.myRefsPanel.setRefs(Collections.<VcsRef>emptyList());
            } else {
                this.myLoadingPanel.stopLoading();
                this.myDataPanel.setData(commitData);
                this.myRefsPanel.setRefs(this.sortRefs(hash, commitData.getRoot()));
            }
            List<String> branches = null;
            if (!(commitData instanceof LoadingDetails)) {
                branches = this.myLogDataHolder.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), hash);
            }
            this.myContainingBranchesPanel.setBranches(branches);
        }
    }

    private void showMessage(String text) {
        this.myLoadingPanel.stopLoading();
        ((CardLayout)this.getLayout()).show(this, MESSAGE_LAYER);
        this.myMessagePanel.setText(text);
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(hash);
        List list = ContainerUtil.sorted(refs, (Comparator)this.myLogDataHolder.getLogProvider(root).getReferenceManager().getComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        return list;
    }

    private static class MessagePanel
    extends JPanel {
        private final JLabel myLabel = new JLabel();

        MessagePanel() {
            super(new BorderLayout());
            this.myLabel.setForeground(UIUtil.getInactiveTextColor());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(0);
            this.add(this.myLabel);
        }

        void setText(String text) {
            this.myLabel.setText(text);
        }
    }

    private static class RefsPanel
    extends JPanel {
        @NotNull
        private final RefPainter myRefPainter;
        @NotNull
        private List<VcsRef> myRefs;

        RefsPanel(@NotNull VcsLogColorManager colorManager) {
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "<init>"));
            }
            this.myRefPainter = new RefPainter(colorManager, false);
            this.myRefs = Collections.emptyList();
            this.setPreferredSize(new Dimension(-1, 26));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myRefPainter.draw((Graphics2D)g, this.myRefs, 0, this.getWidth());
        }

        void setRefs(@NotNull List<VcsRef> refs) {
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "setRefs"));
            }
            this.myRefs = refs;
            this.setVisible(!this.myRefs.isEmpty());
            this.repaint();
        }
    }

    private static class ContainingBranchesPanel
    extends JPanel {
        private final JComponent myLoadingIcon;
        private final JTextField myBranchesList;

        ContainingBranchesPanel() {
            JBLabel label = new JBLabel("Contained in branches: "){

                public Font getFont() {
                    return UIUtil.getLabelFont().deriveFont(2);
                }
            };
            this.myLoadingIcon = new AsyncProcessIcon("Loading...");
            this.myBranchesList = new JBTextField("");
            this.myBranchesList.setEditable(false);
            this.myBranchesList.setBorder(IdeBorderFactory.createEmptyBorder());
            if (UIUtil.isUnderIntelliJLaF()) {
                this.myBranchesList.setBackground(UIUtil.getPanelBackground());
            } else if (UIUtil.isUnderGTKLookAndFeel()) {
                this.myBranchesList.setBorder(new LineBorder(UIUtil.getTextFieldBackground(), 3));
            }
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.add((Component)label);
            this.add(this.myLoadingIcon);
            this.add(this.myBranchesList);
            this.add(Box.createHorizontalGlue());
        }

        void setBranches(@Nullable List<String> branches) {
            if (branches == null) {
                this.myLoadingIcon.setVisible(true);
                this.myBranchesList.setVisible(false);
            } else {
                this.myLoadingIcon.setVisible(false);
                this.myBranchesList.setVisible(true);
                this.myBranchesList.setText(ContainingBranchesPanel.getContainedBranchesText(branches));
            }
        }

        @NotNull
        private static String getContainedBranchesText(@NotNull List<String> branches) {
            if (branches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "com/intellij/vcs/log/ui/frame/DetailsPanel$ContainingBranchesPanel", "getContainedBranchesText"));
            }
            String string = StringUtil.join(branches, (String)", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel$ContainingBranchesPanel", "getContainedBranchesText"));
            }
            return string;
        }
    }

    private static class DataPanel
    extends JEditorPane {
        @NotNull
        private final Project myProject;

        DataPanel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "<init>"));
            }
            super("text/html", "");
            this.setEditable(false);
            this.myProject = project;
            this.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.setOpaque(false);
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.setText("");
            } else {
                String body = DataPanel.getHashText(commit) + "<br/>" + DataPanel.getAuthorText(commit) + "<p>" + this.getMessageText(commit) + "</p>";
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + body + "</body></html>");
                this.setCaretPosition(0);
            }
        }

        private String getMessageText(VcsFullCommitDetails commit) {
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            return "<b>" + IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject) + "</b>" + IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description);
        }

        private static String getHashText(VcsFullCommitDetails commit) {
            return ((Hash)commit.getId()).asString();
        }

        private static String getAuthorText(VcsFullCommitDetails commit) {
            String authorText = commit.getAuthor().getName() + " at " + DateFormatUtil.formatDateTime((long)commit.getAuthorTime());
            if (!commit.getAuthor().equals(commit.getCommitter())) {
                String commitTime = commit.getAuthorTime() != commit.getTimestamp() ? " at " + DateFormatUtil.formatDateTime((long)commit.getTimestamp()) : "";
                authorText = authorText + " (committed by " + commit.getCommitter().getName() + commitTime + ")";
            } else if (commit.getAuthorTime() != commit.getTimestamp()) {
                authorText = authorText + " (committed at " + DateFormatUtil.formatDateTime((long)commit.getTimestamp()) + ")";
            }
            return authorText;
        }
    }
}

