/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
        VirtualFile file;
        XSourcePosition position;
        XValue value;
        String text;
        String selectedText;
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "perform"));
        }
        XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = session.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
        }
        if ((text = selectedText) == null && editor != null) {
            text = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        }
        if (text == null && (value = XDebuggerTreeActionBase.getSelectedValue(dataContext)) != null) {
            text = value.getEvaluationExpression();
        }
        Language language = null;
        if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
            language = XDebuggerEditorBase.getFileTypeLanguage(position.getFile().getFileType());
        }
        if (language == null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null) {
            language = XDebuggerEditorBase.getFileTypeLanguage(file.getFileType());
        }
        XExpressionImpl expression = new XExpressionImpl(StringUtil.notNullize((String)text), language, null);
        new XDebuggerEvaluationDialog(session, editorsProvider, evaluator, expression, stackFrame == null ? null : stackFrame.getSourcePosition()).show();
    }

    @Nullable
    public static String getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (project == null || evaluator == null) {
            return null;
        }
        Document document = editor.getDocument();
        return XDebuggerEvaluateActionHandler.getExpressionText(evaluator.getExpressionInfoAtOffset(project, document, editor.getCaretModel().getOffset(), true), document);
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getExpressionText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getExpressionText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "getDisplayText"));
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getDisplayText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler", "isEnabled"));
        }
        return session.getDebugProcess().getEvaluator() != null;
    }
}

