/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionInputComponent
extends EvaluationInputComponent {
    private final XDebuggerExpressionComboBox myExpressionComboBox;
    private final JPanel myMainPanel;

    public ExpressionInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "<init>"));
        }
        super(XDebuggerBundle.message((String)"xdebugger.dialog.title.evaluate.expression", (Object[])new Object[0]));
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)new JLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.label.expression", (Object[])new Object[0])), "West");
        this.myExpressionComboBox = new XDebuggerExpressionComboBox(project, editorsProvider, "evaluateExpression", sourcePosition);
        this.myExpressionComboBox.getComboBox().setMinimumAndPreferredWidth(250);
        this.myMainPanel.add((Component)this.myExpressionComboBox.getComponent(), "Center");
        if (expression != null) {
            this.myExpressionComboBox.setExpression(expression);
        }
        this.myExpressionComboBox.selectAll();
    }

    @Override
    public void addComponent(JPanel contentPanel, JPanel resultPanel) {
        contentPanel.add((Component)resultPanel, "Center");
        contentPanel.add((Component)this.myMainPanel, "North");
        JBLabel hint = new JBLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.addtowatches.hint", (Object[])new Object[0]), 4);
        hint.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)6, (int)0));
        hint.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        hint.setFontColor(UIUtil.FontColor.BRIGHTER);
        contentPanel.add((Component)hint, "South");
    }

    @Override
    @NotNull
    protected XDebuggerEditorBase getInputEditor() {
        XDebuggerExpressionComboBox xDebuggerExpressionComboBox = this.myExpressionComboBox;
        if (xDebuggerExpressionComboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/ExpressionInputComponent", "getInputEditor"));
        }
        return xDebuggerExpressionComboBox;
    }
}

