/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldStaticFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldStaticFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/fixes/MakeFieldStaticFinalFix", "buildFixUnconditional"));
        }
        MakeFieldStaticFinalFix makeFieldStaticFinalFix = new MakeFieldStaticFinalFix(field.getName());
        if (makeFieldStaticFinalFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeFieldStaticFinalFix", "buildFixUnconditional"));
        }
        return makeFieldStaticFinalFix;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return null;
        }
        if (!FinalUtils.canBeFinal((PsiVariable)field)) {
            return null;
        }
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.static.final.quickfix", this.fieldName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeFieldStaticFinalFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Make static final" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeFieldStaticFinalFix", "getFamilyName"));
        }
        return "Make static final";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("final", true);
        modifierList.setModifierProperty("static", true);
    }
}

