/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;

public class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/siyeh/ig/psiutils/SideEffectChecker", "mayHaveSideEffects"));
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean mayHaveSideEffects = false;

        private SideEffectsVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitElement"));
            }
            if (!this.mayHaveSideEffects) {
                super.visitElement(element);
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitAssignmentExpression"));
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitAssignmentExpression(expression);
            this.mayHaveSideEffects = true;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitMethodCallExpression"));
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method != null && (PropertyUtil.isSimpleGetter((PsiMethod)method) || ControlFlowAnalyzer.isPure(method))) {
                return;
            }
            this.mayHaveSideEffects = true;
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitNewExpression"));
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitNewExpression(expression);
            this.mayHaveSideEffects = true;
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitPostfixExpression"));
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitPostfixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.mayHaveSideEffects = true;
            }
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor", "visitPrefixExpression"));
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitPrefixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.mayHaveSideEffects = true;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }
    }
}

