/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;

public class ConcatenationUtils {
    private ConcatenationUtils() {
    }

    public static boolean isConcatenation(PsiElement element) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUS)) {
            return false;
        }
        PsiExpression[] operands = expression.getOperands();
        if (operands.length <= 1) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            for (PsiExpression operand : operands) {
                if (!ConcatenationUtils.hasStringType(operand)) continue;
                return true;
            }
            return false;
        }
        return type.equalsToText("java.lang.String");
    }

    private static boolean hasStringType(PsiExpression expression) {
        PsiType type = expression.getType();
        return type != null && type.equalsToText("java.lang.String");
    }
}

