/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actionSystem;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;

public final class ImageEditorActionUtil {
    private ImageEditorActionUtil() {
    }

    public static ImageEditor getValidEditor(AnActionEvent e) {
        ImageEditor editor = ImageEditorActionUtil.getEditor(e);
        if (editor != null && editor.isValid()) {
            return editor;
        }
        return null;
    }

    public static ImageEditor getEditor(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor instanceof ImageFileEditor) {
            ImageFileEditor fileEditor = (ImageFileEditor)editor;
            return fileEditor.getImageEditor();
        }
        return null;
    }

    public static boolean setEnabled(AnActionEvent e) {
        ImageEditor editor = ImageEditorActionUtil.getValidEditor(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(editor != null);
        return presentation.isEnabled();
    }
}

