/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.view;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.NamedItemsListEditor;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import gnu.trove.Equality;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.template.TemplatesManager;
import org.jetbrains.generate.tostring.view.ToStringTemplateConfigurable;

public class TemplatesPanel
extends NamedItemsListEditor<TemplateResource> {
    private static final Namer<TemplateResource> NAMER = new Namer<TemplateResource>(){

        public String getName(TemplateResource templateResource) {
            return templateResource.getFileName();
        }

        public boolean canRename(TemplateResource item) {
            return !item.isDefault();
        }

        public void setName(TemplateResource templateResource, String name) {
            templateResource.setFileName(name);
        }
    };
    private static final Factory<TemplateResource> FACTORY = new Factory<TemplateResource>(){

        public TemplateResource create() {
            return new TemplateResource();
        }
    };
    private static final Cloner<TemplateResource> CLONER = new Cloner<TemplateResource>(){

        public TemplateResource cloneOf(TemplateResource templateResource) {
            if (templateResource.isDefault()) {
                return templateResource;
            }
            return this.copyOf(templateResource);
        }

        public TemplateResource copyOf(TemplateResource templateResource) {
            TemplateResource result = new TemplateResource();
            result.setFileName(templateResource.getFileName());
            result.setTemplate(templateResource.getTemplate());
            return result;
        }
    };
    private static final Equality<TemplateResource> COMPARER = new Equality<TemplateResource>(){

        public boolean equals(TemplateResource o1, TemplateResource o2) {
            return Comparing.equal((String)o1.getTemplate(), (String)o2.getTemplate()) && Comparing.equal((String)o1.getFileName(), (String)o2.getFileName());
        }
    };

    public TemplatesPanel() {
        super(NAMER, FACTORY, CLONER, COMPARER, new ArrayList<TemplateResource>(TemplatesManager.getInstance().getAllTemplates()));
    }

    @Nls
    public String getDisplayName() {
        return "Templates";
    }

    protected String subjDisplayName() {
        return "template";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        return super.isModified() || !Comparing.equal((Object)TemplatesManager.getInstance().getDefaultTemplate(), (Object)this.getSelectedItem());
    }

    protected boolean canDelete(TemplateResource item) {
        return !item.isDefault();
    }

    protected UnnamedConfigurable createConfigurable(TemplateResource item) {
        return new ToStringTemplateConfigurable(item);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        TemplatesManager.getInstance().setTemplates(this.getItems());
        TemplateResource selection = (TemplateResource)this.getSelectedItem();
        if (selection != null) {
            TemplatesManager.getInstance().setDefaultTemplate(selection);
        }
    }
}

