/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.impl;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.IDEARootFormatter;
import com.intellij.cvsSupport2.connections.pserver.PServerLoginProvider;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutProjectOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.history.ComparableVcsRevisionOnOperation;
import com.intellij.cvsSupport2.impl.ModuleChooser;
import com.intellij.openapi.cvsIntegration.CvsModule;
import com.intellij.openapi.cvsIntegration.CvsRepository;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.cvsIntegration.CvsServices;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class CvsServicesImpl
extends CvsServices {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.impl.CvsServicesImpl");

    @Override
    public CvsModule[] chooseModules(Project project, boolean allowRootSelection, boolean allowMultipleSelection, boolean allowFilesSelection, String title, String selectModulePageTitle) {
        ModuleChooser moduleChooser = new ModuleChooser(project, allowFilesSelection, allowMultipleSelection, allowRootSelection, title, selectModulePageTitle);
        moduleChooser.show();
        if (!moduleChooser.isOK()) {
            return null;
        }
        return moduleChooser.getSelectedModules();
    }

    @Override
    public CvsRepository[] getConfiguredRepositories() {
        List<CvsRootConfiguration> configurations = CvsApplicationLevelConfiguration.getInstance().CONFIGURATIONS;
        CvsRepository[] result = new CvsRepository[configurations.size()];
        for (int i = 0; i < configurations.size(); ++i) {
            result[i] = configurations.get(i).createCvsRepository();
        }
        return result;
    }

    private static ComparableVcsRevisionOnOperation createCvsVersionOn(CvsModule module, Project project) {
        CvsRootConfiguration rootConfiguration = CvsApplicationLevelConfiguration.getInstance().getConfigurationForCvsRoot(module.getRepository().getStringRepresentation());
        CvsConnectionSettings env = new IDEARootFormatter(rootConfiguration).createConfiguration();
        GetFileContentOperation operation = new GetFileContentOperation(new File(module.getPathInCvs()), env, new SimpleRevision(module.getRevision()));
        return new ComparableVcsRevisionOnOperation(operation, project);
    }

    @Override
    public void showDifferencesForFiles(CvsModule first, CvsModule second, Project project) throws Exception {
        AbstractVcsHelper.getInstance((Project)project).showDifferences((VcsFileRevision)CvsServicesImpl.createCvsVersionOn(first, project), (VcsFileRevision)CvsServicesImpl.createCvsVersionOn(second, project), new File(first.getPathInCvs()));
    }

    @Override
    public String getScrambledPasswordForPServerCvsRoot(String cvsRoot) {
        return PServerLoginProvider.getInstance().getScrambledPasswordForCvsRoot(cvsRoot);
    }

    @Override
    public boolean saveRepository(CvsRepository repository) {
        CvsApplicationLevelConfiguration configuration = CvsApplicationLevelConfiguration.getInstance();
        CvsRootConfiguration config = CvsRootConfiguration.createOn(repository);
        if (configuration.CONFIGURATIONS.contains(config)) {
            return false;
        }
        configuration.CONFIGURATIONS.add(config);
        return configuration.CONFIGURATIONS.contains(config);
    }

    @Override
    public void openInEditor(Project project, CvsModule cvsFile) {
        CvsRepository repository = cvsFile.getRepository();
        RevisionOrDate revisionOrDate = RevisionOrDateImpl.createOn(new DateOrRevisionSettings().updateFrom(repository.getDateOrRevision()));
        GetFileContentOperation operation = new GetFileContentOperation(new File(cvsFile.getPathInCvs()), CvsRootConfiguration.createOn(repository), revisionOrDate);
        ComparableVcsRevisionOnOperation revision = new ComparableVcsRevisionOnOperation(operation, project);
        VcsVirtualFile vcsVirtualFile = new VcsVirtualFile(cvsFile.getPathInCvs(), (VcsFileRevision)revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, (VirtualFile)vcsVirtualFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, false);
    }

    @Override
    public byte[] getFileContent(Project project, CvsModule cvsFile) throws IOException {
        GetFileContentOperation operation = new GetFileContentOperation(new File(cvsFile.getPathInCvs()), CvsRootConfiguration.createOn(cvsFile.getRepository()), new SimpleRevision(cvsFile.getRevision()));
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"operation.name.load.file.content", (Object[])new Object[0]), (CvsOperation)operation, false), CvsOperationExecutorCallback.EMPTY);
        if (!executor.hasNoErrors()) {
            throw new RuntimeException(executor.getFirstError());
        }
        if (operation.isDeleted()) {
            throw new IOException(CvsBundle.message((String)"exception.text.revision.has.been.deleted", (Object[])new Object[0]));
        }
        return operation.getFileBytes();
    }

    @Override
    public CvsResult checkout(String[] modules, File checkoutTo, String directory, boolean makeNewFilesReadOnly, boolean pruneEmptyDirectories, Object keywordSubstitution, Project project, CvsRepository repository) {
        LOG.assertTrue(modules.length > 0);
        CheckoutProjectOperation operation = new CheckoutProjectOperation(modules, CvsRootConfiguration.createOn(repository), makeNewFilesReadOnly, checkoutTo, directory, pruneEmptyDirectories, (KeywordSubstitution)keywordSubstitution);
        CvsOperationExecutor executor = new CvsOperationExecutor(project);
        executor.performActionSync(new CommandCvsHandler(CvsBundle.message((String)"operation.name.checkout", (Object[])new Object[0]), (CvsOperation)operation, true), CvsOperationExecutorCallback.EMPTY);
        return executor.getResult();
    }
}

