/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.MockDocumentEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Producer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorModificationUtil {
    private EditorModificationUtil() {
    }

    public static void deleteSelectedText(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            EditorModificationUtil.deleteBlockSelection(editor);
        }
        if (!selectionModel.hasSelection()) {
            return;
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        VisualPosition selectionStartPosition = selectionModel.getSelectionStartPosition();
        if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets() && selectionStartPosition != null) {
            editor.getCaretModel().moveToVisualPosition(selectionStartPosition);
        } else {
            editor.getCaretModel().moveToOffset(selectionStart);
        }
        selectionModel.removeSelection();
        editor.getDocument().deleteString(selectionStart, selectionEnd);
        if (editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static void deleteSelectedTextForAllCarets(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/EditorModificationUtil", "deleteSelectedTextForAllCarets"));
        }
        editor.getCaretModel().runForEachCaret(new CaretAction(){

            @Override
            public void perform(Caret caret) {
                EditorModificationUtil.deleteSelectedText(editor);
            }
        });
    }

    public static void deleteBlockSelection(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasBlockSelection()) {
            return;
        }
        LogicalPosition blockStart = selectionModel.getBlockStart();
        LogicalPosition blockEnd = selectionModel.getBlockEnd();
        if (blockStart == null || blockEnd == null) {
            return;
        }
        int startLine = blockStart.line;
        int endLine = blockEnd.line;
        int[] starts = selectionModel.getBlockSelectionStarts();
        int[] ends = selectionModel.getBlockSelectionEnds();
        for (int i = starts.length - 1; i >= 0; --i) {
            editor.getDocument().deleteString(starts[i], ends[i]);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorModificationUtil.zeroWidthBlockSelectionAtCaretColumn(editor, startLine, endLine);
    }

    public static void zeroWidthBlockSelectionAtCaretColumn(Editor editor, int startLine, int endLine) {
        int caretColumn = editor.getCaretModel().getLogicalPosition().column;
        editor.getSelectionModel().setBlockSelection(new LogicalPosition(startLine, caretColumn), new LogicalPosition(endLine, caretColumn));
    }

    public static void insertStringAtCaret(Editor editor, @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/EditorModificationUtil", "insertStringAtCaret"));
        }
        EditorModificationUtil.insertStringAtCaret(editor, s, false, true);
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/EditorModificationUtil", "insertStringAtCaret"));
        }
        return EditorModificationUtil.insertStringAtCaret(editor, s, toProcessOverwriteMode, s.length());
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/EditorModificationUtil", "insertStringAtCaret"));
        }
        return EditorModificationUtil.insertStringAtCaret(editor, s, toProcessOverwriteMode, toMoveCaret, s.length());
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, int caretShift) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/EditorModificationUtil", "insertStringAtCaret"));
        }
        return EditorModificationUtil.insertStringAtCaret(editor, s, toProcessOverwriteMode, true, caretShift);
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/EditorModificationUtil", "insertStringAtCaret"));
        }
        int result = EditorModificationUtil.insertStringAtCaretNoScrolling(editor, s, toProcessOverwriteMode, toMoveCaret, caretShift);
        if (toMoveCaret && editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        return result;
    }

    private static int insertStringAtCaretNoScrolling(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/EditorModificationUtil", "insertStringAtCaretNoScrolling"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            VisualPosition startPosition = selectionModel.getSelectionStartPosition();
            if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets() && startPosition != null) {
                editor.getCaretModel().moveToVisualPosition(startPosition);
            } else {
                editor.getCaretModel().moveToOffset(selectionModel.getSelectionStart(), true);
            }
        }
        editor.getSoftWrapModel().beforeDocumentChangeAtCaret();
        int oldOffset = editor.getCaretModel().getOffset();
        String filler = EditorModificationUtil.calcStringToFillVirtualSpace(editor);
        if (filler.length() > 0) {
            s = filler + s;
        }
        Document document = editor.getDocument();
        if (editor.isInsertMode() || !toProcessOverwriteMode) {
            if (selectionModel.hasSelection()) {
                oldOffset = selectionModel.getSelectionStart();
                document.replaceString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), s);
            } else {
                document.insertString(oldOffset, s);
            }
        } else {
            EditorModificationUtil.deleteSelectedText(editor);
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            if (lineNumber >= document.getLineCount()) {
                return EditorModificationUtil.insertStringAtCaretNoScrolling(editor, s, false, toMoveCaret, s.length());
            }
            int endOffset = document.getLineEndOffset(lineNumber);
            document.replaceString(oldOffset, Math.min(endOffset, oldOffset + s.length()), s);
        }
        int offset = oldOffset + filler.length() + caretShift;
        if (toMoveCaret) {
            editor.getCaretModel().moveToOffset(offset, true);
            selectionModel.removeSelection();
        } else if (editor.getCaretModel().getOffset() != oldOffset) {
            editor.getCaretModel().moveToOffset(oldOffset);
        }
        return offset;
    }

    @Nullable
    public static TextRange pasteTransferable(Editor editor, @Nullable Producer<Transferable> producer) {
        EditorCopyPasteHelper helper = EditorCopyPasteHelper.getInstance();
        if (producer == null) {
            TextRange[] ranges = helper.pasteFromClipboard(editor);
            return ranges != null && ranges.length == 1 ? ranges[0] : null;
        }
        Transferable transferable = (Transferable)producer.produce();
        if (transferable == null) {
            return null;
        }
        TextRange[] ranges = helper.pasteTransferable(editor, transferable);
        return ranges != null && ranges.length == 1 ? ranges[0] : null;
    }

    public static void pasteTransferableAsBlock(Editor editor, @Nullable Producer<Transferable> producer) {
        int caretLine;
        Transferable content = EditorModificationUtil.getTransferable(producer);
        if (content == null) {
            return;
        }
        String text = EditorModificationUtil.getStringContent(content);
        if (text == null) {
            return;
        }
        int originalCaretLine = caretLine = editor.getCaretModel().getLogicalPosition().line;
        int selectedLinesCount = 0;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            LogicalPosition start = selectionModel.getBlockStart();
            LogicalPosition end = selectionModel.getBlockEnd();
            assert (start != null);
            assert (end != null);
            LogicalPosition caret = new LogicalPosition(Math.min(start.line, end.line), Math.min(start.column, end.column));
            selectedLinesCount = Math.abs(end.line - start.line);
            caretLine = caret.line;
            EditorModificationUtil.deleteSelectedText(editor);
            editor.getCaretModel().moveToLogicalPosition(caret);
        }
        LogicalPosition caretToRestore = editor.getCaretModel().getLogicalPosition();
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false);
        if (lines.length > 1 || selectedLinesCount == 0) {
            int longestLineLength = 0;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                longestLineLength = Math.max(longestLineLength, line.length());
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(caretLine + i, caretToRestore.column));
                EditorModificationUtil.insertStringAtCaret(editor, line, false, true);
            }
            caretToRestore = new LogicalPosition(originalCaretLine, caretToRestore.column + longestLineLength);
        } else {
            for (int i = 0; i <= selectedLinesCount; ++i) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(caretLine + i, caretToRestore.column));
                EditorModificationUtil.insertStringAtCaret(editor, text, false, true);
            }
            caretToRestore = new LogicalPosition(originalCaretLine, caretToRestore.column + text.length());
        }
        editor.getCaretModel().moveToLogicalPosition(caretToRestore);
        EditorModificationUtil.zeroWidthBlockSelectionAtCaretColumn(editor, caretLine, caretLine + selectedLinesCount);
    }

    @Nullable
    private static String getStringContent(@NotNull Transferable content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/editor/EditorModificationUtil", "getStringContent"));
        }
        RawText raw = RawText.fromTransferable(content);
        if (raw != null) {
            return raw.rawText;
        }
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException ignore) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static Transferable getTransferable(Producer<Transferable> producer) {
        Transferable content = null;
        if (producer != null) {
            content = (Transferable)producer.produce();
        } else {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            if (manager.areDataFlavorsAvailable(DataFlavor.stringFlavor)) {
                content = manager.getContents();
            }
        }
        return content;
    }

    public static int calcAfterLineEnd(Editor editor) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        int lineNumber = logicalPosition.line;
        int columnNumber = logicalPosition.column;
        if (lineNumber >= document.getLineCount()) {
            return columnNumber;
        }
        int caretOffset = caretModel.getOffset();
        int anchorLineEndOffset = document.getLineEndOffset(lineNumber);
        List<? extends SoftWrap> softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(logicalPosition.line);
        for (SoftWrap softWrap : softWraps) {
            boolean visuallyBeforeSoftWrap;
            if (!editor.getSoftWrapModel().isVisible(softWrap)) continue;
            int softWrapOffset = softWrap.getStart();
            if (softWrapOffset == caretOffset) {
                VisualPosition position = editor.offsetToVisualPosition(caretOffset - 1);
                VisualPosition visualCaret = caretModel.getVisualPosition();
                if (position.line == visualCaret.line) {
                    return visualCaret.column - position.column - 1;
                }
            }
            if (softWrapOffset > caretOffset) {
                anchorLineEndOffset = softWrapOffset;
                break;
            }
            if (softWrapOffset != caretOffset || !(visuallyBeforeSoftWrap = caretModel.getVisualPosition().line < editor.offsetToVisualPosition((int)caretOffset).line)) continue;
            anchorLineEndOffset = softWrapOffset;
            break;
        }
        int lineEndColumnNumber = editor.offsetToLogicalPosition((int)anchorLineEndOffset).column;
        return columnNumber - lineEndColumnNumber;
    }

    public static String calcStringToFillVirtualSpace(Editor editor) {
        int afterLineEnd = EditorModificationUtil.calcAfterLineEnd(editor);
        if (afterLineEnd > 0) {
            return EditorModificationUtil.calcStringToFillVirtualSpace(editor, afterLineEnd);
        }
        return "";
    }

    public static String calcStringToFillVirtualSpace(Editor editor, int afterLineEnd) {
        boolean atLineStart;
        Project project = editor.getProject();
        StringBuilder buf = new StringBuilder();
        Document doc = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        boolean bl = atLineStart = caretOffset >= doc.getTextLength() || doc.getLineStartOffset(doc.getLineNumber(caretOffset)) == caretOffset;
        if (atLineStart && project != null) {
            String properIndent;
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance(project).commitDocument(doc);
            String string = properIndent = offset >= doc.getTextLength() ? "" : CodeStyleFacade.getInstance(project).getLineIndent(doc, offset);
            if (properIndent != null) {
                int tabSize = editor.getSettings().getTabSize(project);
                for (int i = 0; i < properIndent.length(); ++i) {
                    if (properIndent.charAt(i) == ' ') {
                        --afterLineEnd;
                    } else if (properIndent.charAt(i) == '\t') {
                        if (afterLineEnd < tabSize) break;
                        afterLineEnd -= tabSize;
                    }
                    buf.append(properIndent.charAt(i));
                    if (afterLineEnd == 0) break;
                }
            }
        }
        for (int i = 0; i < afterLineEnd; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static void typeInStringAtCaretHonorBlockSelection(Editor editor, String str, boolean toProcessOverwriteMode) throws ReadOnlyFragmentModificationException {
        Document doc = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            RangeMarker guard = selectionModel.getBlockSelectionGuard();
            if (guard != null) {
                MockDocumentEvent evt = new MockDocumentEvent(doc, editor.getCaretModel().getOffset());
                ReadOnlyFragmentModificationException e = new ReadOnlyFragmentModificationException(evt, guard);
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            } else {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                assert (start != null);
                assert (end != null);
                int column = Math.min(start.column, end.column);
                int startLine = Math.min(start.line, end.line);
                int endLine = Math.max(start.line, end.line);
                EditorModificationUtil.deleteBlockSelection(editor);
                for (int i = startLine; i <= endLine; ++i) {
                    editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, column));
                    EditorModificationUtil.insertStringAtCaret(editor, str, toProcessOverwriteMode, true);
                }
                selectionModel.setBlockSelection(new LogicalPosition(startLine, column + str.length()), new LogicalPosition(endLine, column + str.length()));
            }
        } else {
            EditorModificationUtil.insertStringAtCaret(editor, str, toProcessOverwriteMode, true);
        }
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/editor/EditorModificationUtil", "typeInStringAtCaretHonorMultipleCarets"));
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, int caretShift) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/editor/EditorModificationUtil", "typeInStringAtCaretHonorMultipleCarets"));
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, caretShift);
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, boolean toProcessOverwriteMode) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/editor/EditorModificationUtil", "typeInStringAtCaretHonorMultipleCarets"));
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, toProcessOverwriteMode, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(final Editor editor, final @NotNull String str, final boolean toProcessOverwriteMode, final int caretShift) throws ReadOnlyFragmentModificationException {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/editor/EditorModificationUtil", "typeInStringAtCaretHonorMultipleCarets"));
        }
        Document doc = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            RangeMarker guard = selectionModel.getBlockSelectionGuard();
            if (guard != null) {
                MockDocumentEvent evt = new MockDocumentEvent(doc, editor.getCaretModel().getOffset());
                ReadOnlyFragmentModificationException e = new ReadOnlyFragmentModificationException(evt, guard);
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            } else {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                assert (start != null);
                assert (end != null);
                int column = Math.min(start.column, end.column);
                int startLine = Math.min(start.line, end.line);
                int endLine = Math.max(start.line, end.line);
                EditorModificationUtil.deleteBlockSelection(editor);
                for (int i = startLine; i <= endLine; ++i) {
                    editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, column));
                    EditorModificationUtil.insertStringAtCaret(editor, str, toProcessOverwriteMode, true, caretShift);
                }
                selectionModel.setBlockSelection(new LogicalPosition(startLine, column + str.length()), new LogicalPosition(endLine, column + str.length()));
            }
        } else {
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                @Override
                public void perform(Caret caret) {
                    EditorModificationUtil.insertStringAtCaretNoScrolling(editor, str, toProcessOverwriteMode, true, caretShift);
                }
            });
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static void moveAllCaretsRelatively(@NotNull Editor editor, final int caretShift) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/EditorModificationUtil", "moveAllCaretsRelatively"));
        }
        editor.getCaretModel().runForEachCaret(new CaretAction(){

            @Override
            public void perform(Caret caret) {
                caret.moveToOffset(caret.getOffset() + caretShift);
            }
        });
    }

    public static void moveCaretRelatively(@NotNull Editor editor, int caretShift) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/EditorModificationUtil", "moveCaretRelatively"));
        }
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToOffset(caretModel.getOffset() + caretShift);
    }
}

