/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileSaverDescriptor
extends FileChooserDescriptor
implements Cloneable {
    private final List<String> extensions;

    public FileSaverDescriptor(@NotNull String title, @NotNull String description, String ... extensions) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/fileChooser/FileSaverDescriptor", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/fileChooser/FileSaverDescriptor", "<init>"));
        }
        super(true, true, true, true, false, false);
        this.setTitle(title);
        this.setDescription(description);
        this.extensions = Arrays.asList(extensions);
    }

    @Override
    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
        return this.extensions.isEmpty() || file.isDirectory() ? super.isFileVisible(file, showHiddenFiles) : this.extensions.contains(file.getExtension());
    }

    public String[] getFileExtensions() {
        return ArrayUtil.toStringArray(this.extensions);
    }
}

