/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabeledComponent<Comp extends JComponent>
extends JPanel
implements PanelWithAnchor {
    private final JBLabel myLabel = new JBLabel();
    private Comp myComponent;
    private String myLabelConstraints = "North";
    private JComponent myAnchor;
    private static final String[] LABEL_BORDER_CONSTRAINS = new String[]{"North", "East", "South", "West"};

    public LabeledComponent() {
        super(new BorderLayout(10, 2));
        this.insertLabel();
    }

    @NotNull
    public static <Comp extends JComponent> LabeledComponent<Comp> create(@NotNull Comp component, @NotNull String text) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/LabeledComponent", "create"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/ui/LabeledComponent", "create"));
        }
        LabeledComponent<Comp> labeledComponent = new LabeledComponent<Comp>();
        labeledComponent.setComponent(component);
        labeledComponent.setText(text);
        LabeledComponent<Comp> labeledComponent2 = labeledComponent;
        if (labeledComponent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/LabeledComponent", "create"));
        }
        return labeledComponent2;
    }

    private void insertLabel() {
        this.remove(this.myLabel);
        this.add((Component)this.myLabel, this.myLabelConstraints);
        this.setAnchor(this.myLabel);
    }

    public void setText(String textWithMnemonic) {
        if (!StringUtil.endsWithChar((CharSequence)textWithMnemonic, (char)':')) {
            textWithMnemonic = textWithMnemonic + ":";
        }
        TextWithMnemonic withMnemonic = TextWithMnemonic.fromTextWithMnemonic(textWithMnemonic);
        withMnemonic.setToLabel(this.myLabel);
    }

    public String getText() {
        String text = TextWithMnemonic.fromLabel(this.myLabel).getTextWithMnemonic();
        if (StringUtil.endsWithChar((CharSequence)text, (char)':')) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    public void setComponentClass(@NonNls String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (className != null) {
            Class<?> aClass = this.getClass().getClassLoader().loadClass(className);
            JComponent component = (JComponent)aClass.newInstance();
            this.setComponent(component);
        } else {
            this.setComponent(null);
        }
    }

    public void setComponent(Comp component) {
        if (this.myComponent != null) {
            this.remove((Component)this.myComponent);
        }
        this.myComponent = component;
        if (this.myComponent != null) {
            this.add((Component)this.myComponent, "Center");
        }
        if (this.myComponent instanceof ComponentWithBrowseButton && !(this.myComponent instanceof TextFieldWithBrowseButton)) {
            this.myLabel.setLabelFor((Component)((ComponentWithBrowseButton)this.myComponent).getChildComponent());
        } else {
            this.myLabel.setLabelFor((Component)this.myComponent);
        }
    }

    public String getComponentClass() {
        if (this.myComponent == null) {
            return null;
        }
        return this.getComponent().getClass().getName();
    }

    public Comp getComponent() {
        return this.myComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myComponent != null) {
            ((JComponent)this.myComponent).setEnabled(enabled);
        }
        this.myLabel.setEnabled(enabled);
    }

    public void setLabelLocation(@NonNls String borderConstrains) {
        String constrains = LabeledComponent.findBorderConstrains(borderConstrains);
        if (constrains == null || constrains.equals(this.myLabelConstraints)) {
            return;
        }
        this.myLabelConstraints = borderConstrains;
        this.insertLabel();
    }

    public String getLabelLocation() {
        return this.myLabelConstraints;
    }

    public Insets getLabelInsets() {
        return this.myLabel.getInsets();
    }

    public void setLabelInsets(Insets insets) {
        if (Comparing.equal((Object)insets, (Object)this.getLabelInsets())) {
            return;
        }
        this.myLabel.setBorder(IdeBorderFactory.createEmptyBorder(insets));
    }

    private static String findBorderConstrains(String str) {
        for (String constrain : LABEL_BORDER_CONSTRAINS) {
            if (!constrain.equals(str)) continue;
            return constrain;
        }
        return null;
    }

    public String getRawText() {
        return this.myLabel.getText().replace("\u001b", "");
    }

    public JBLabel getLabel() {
        return this.myLabel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent labelAnchor) {
        this.myAnchor = labelAnchor;
        this.myLabel.setAnchor(labelAnchor);
    }

    public static class TextWithMnemonic {
        private final String myText;
        private final int myMnemoniIndex;

        public TextWithMnemonic(String text, int mnemoniIndex) {
            this.myText = text;
            this.myMnemoniIndex = mnemoniIndex;
        }

        public void setToLabel(JLabel label) {
            label.setText(this.myText);
            if (this.myMnemoniIndex != -1) {
                label.setDisplayedMnemonic(this.myText.charAt(this.myMnemoniIndex));
            } else {
                label.setDisplayedMnemonic(0);
            }
            label.setDisplayedMnemonicIndex(this.myMnemoniIndex);
        }

        public String getTextWithMnemonic() {
            if (this.myMnemoniIndex == -1) {
                return this.myText;
            }
            return this.myText.substring(0, this.myMnemoniIndex) + "&" + this.myText.substring(this.myMnemoniIndex);
        }

        public static TextWithMnemonic fromTextWithMnemonic(String textWithMnemonic) {
            int mnemonicIndex = textWithMnemonic.indexOf(38);
            if (mnemonicIndex == -1) {
                return new TextWithMnemonic(textWithMnemonic, -1);
            }
            textWithMnemonic = textWithMnemonic.substring(0, mnemonicIndex) + textWithMnemonic.substring(mnemonicIndex + 1);
            return new TextWithMnemonic(textWithMnemonic, mnemonicIndex);
        }

        public static TextWithMnemonic fromLabel(JLabel label) {
            return new TextWithMnemonic(label.getText(), label.getDisplayedMnemonicIndex());
        }
    }
}

