/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ByTypeArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final Set<ArrangementSettingsToken> myTypes;

    public ByTypeArrangementEntryMatcher(@NotNull ArrangementSettingsToken interestedType) {
        if (interestedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interestedType", "com/intellij/psi/codeStyle/arrangement/match/ByTypeArrangementEntryMatcher", "<init>"));
        }
        this.myTypes = ContainerUtilRt.newHashSet();
        this.myTypes.add(interestedType);
    }

    public ByTypeArrangementEntryMatcher(@NotNull Collection<ArrangementSettingsToken> interestedTypes) {
        if (interestedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interestedTypes", "com/intellij/psi/codeStyle/arrangement/match/ByTypeArrangementEntryMatcher", "<init>"));
        }
        this.myTypes = ContainerUtilRt.newHashSet();
        this.myTypes.addAll(interestedTypes);
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/match/ByTypeArrangementEntryMatcher", "isMatched"));
        }
        if (entry instanceof TypeAwareArrangementEntry) {
            return ((TypeAwareArrangementEntry)entry).getTypes().containsAll(this.myTypes);
        }
        return false;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        Set<ArrangementSettingsToken> set = this.myTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/ByTypeArrangementEntryMatcher", "getTypes"));
        }
        return set;
    }

    public int hashCode() {
        return ((Object)this.myTypes).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByTypeArrangementEntryMatcher that = (ByTypeArrangementEntryMatcher)o;
        return ((Object)this.myTypes).equals(that.myTypes);
    }

    public String toString() {
        return String.format("of type '%s'", this.myTypes);
    }
}

