/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StdArrangementMatchRule
extends ArrangementMatchRule
implements Cloneable,
Comparable<StdArrangementMatchRule> {
    public StdArrangementMatchRule(@NotNull StdArrangementEntryMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "<init>"));
        }
        super(matcher);
    }

    public StdArrangementMatchRule(@NotNull StdArrangementEntryMatcher matcher, @NotNull ArrangementSettingsToken orderType) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "<init>"));
        }
        if (orderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderType", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "<init>"));
        }
        super(matcher, orderType);
    }

    @Override
    @NotNull
    public StdArrangementEntryMatcher getMatcher() {
        StdArrangementEntryMatcher stdArrangementEntryMatcher = (StdArrangementEntryMatcher)super.getMatcher();
        if (stdArrangementEntryMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "getMatcher"));
        }
        return stdArrangementEntryMatcher;
    }

    public StdArrangementMatchRule clone() {
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(this.getMatcher().getCondition().clone()), this.getOrderType());
    }

    @Override
    public int compareTo(@NotNull StdArrangementMatchRule o) {
        String entryType1;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "compareTo"));
        }
        Set<ArrangementSettingsToken> tokens = ArrangementUtil.extractTokens(this.getMatcher().getCondition()).keySet();
        Set<ArrangementSettingsToken> tokens1 = ArrangementUtil.extractTokens(o.getMatcher().getCondition()).keySet();
        if (tokens1.containsAll(tokens)) {
            return tokens.containsAll(tokens1) ? 0 : 1;
        }
        if (tokens.containsAll(tokens1)) {
            return -1;
        }
        String entryType = StdArrangementMatchRule.getEntryType(tokens);
        int compare = StringUtil.compare((String)entryType, (String)(entryType1 = StdArrangementMatchRule.getEntryType(tokens1)), (boolean)false);
        if (compare != 0 || tokens.size() == tokens1.size()) {
            return compare;
        }
        return tokens.size() < tokens1.size() ? 1 : -1;
    }

    @Nullable
    private static String getEntryType(@NotNull Set<ArrangementSettingsToken> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "getEntryType"));
        }
        for (ArrangementSettingsToken token : tokens) {
            if (!StdArrangementTokenType.ENTRY_TYPE.is(token)) continue;
            return token.getId();
        }
        return null;
    }
}

