/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImageList
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance(SystemImageList.class);
    private final JButton myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    private final LocalSdk mySdk;
    private TableView<AvdWizardConstants.SystemImageDescription> myTable = new TableView();
    private ListTableModel<AvdWizardConstants.SystemImageDescription> myModel = new ListTableModel(new ColumnInfo[0]);
    private Set<SystemImageSelectionListener> myListeners = Sets.newHashSet();
    private Predicate<ISystemImage> myFilter;
    private static final ColumnInfo[] ourColumnInfos = new ColumnInfo[]{new SystemImageColumnInfo("Release Name"){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            String codeName = SdkVersionInfo.getCodeName((int)systemImage.target.getVersion().getApiLevel());
            String maybeDeprecated = systemImage.target.getVersion().getApiLevel() < 8 ? " (Deprecated)" : "";
            return codeName == null ? "Unknown" : codeName + maybeDeprecated;
        }
    }, new SystemImageColumnInfo("API Level", 100){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            return systemImage.target.getVersion().getApiString();
        }

        @Override
        @Nullable
        public Comparator<AvdWizardConstants.SystemImageDescription> getComparator() {
            return new Comparator<AvdWizardConstants.SystemImageDescription>(){

                @Override
                public int compare(AvdWizardConstants.SystemImageDescription o1, AvdWizardConstants.SystemImageDescription o2) {
                    return o1.target.getVersion().getApiLevel() - o2.target.getVersion().getApiLevel();
                }
            };
        }
    }, new SystemImageColumnInfo("ABI", 100){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            return systemImage.systemImage.getAbiType();
        }
    }, new SystemImageColumnInfo("Target"){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            return systemImage.target.getFullName();
        }
    }};

    public SystemImageList() {
        AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (androidSdkData == null) {
            throw new RuntimeException("No SDK Found");
        }
        this.mySdk = androidSdkData.getLocalSdk();
        this.myModel.setColumnInfos(ourColumnInfos);
        this.myModel.setSortable(true);
        this.refreshImages(true);
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.setLayout(new BorderLayout());
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JPanel southPanel = new JPanel(new FlowLayout(2));
        southPanel.add(this.myRefreshButton);
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.refreshImages(true);
            }
        });
        this.add((Component)southPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(this);
    }

    public void refreshImages(boolean forceRefresh) {
        if (forceRefresh) {
            this.mySdk.clearLocalPkg(PkgType.PKG_ALL);
        }
        ArrayList targets = Lists.newArrayList((Object[])this.mySdk.getTargets());
        ArrayList items = Lists.newArrayList();
        for (IAndroidTarget target : targets) {
            ISystemImage[] systemImages = target.getSystemImages();
            if (systemImages == null) continue;
            for (ISystemImage image : systemImages) {
                if (this.myFilter != null && !this.myFilter.apply((Object)image)) continue;
                items.add(new AvdWizardConstants.SystemImageDescription(target, image));
            }
        }
        this.myModel.setItems((List)items);
    }

    public void setFilter(Predicate<ISystemImage> filter) {
        this.myFilter = filter;
    }

    public void addSelectionListener(SystemImageSelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void removeSelectionListener(SystemImageSelectionListener listener) {
        this.myListeners.remove(listener);
    }

    public void setSelectedImage(@Nullable AvdWizardConstants.SystemImageDescription selectedImage) {
        if (selectedImage != null) {
            for (AvdWizardConstants.SystemImageDescription listItem : this.myModel.getItems()) {
                if (!selectedImage.target.getVersion().equals((Object)listItem.target.getVersion()) || !selectedImage.systemImage.getAbiType().equals(listItem.systemImage.getAbiType())) continue;
                this.myTable.setSelection((Collection)ImmutableSet.of((Object)listItem));
                return;
            }
        } else {
            this.myTable.clearSelection();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        AvdWizardConstants.SystemImageDescription selected = (AvdWizardConstants.SystemImageDescription)this.myTable.getSelectedObject();
        for (SystemImageSelectionListener listener : this.myListeners) {
            listener.onSystemImageSelected(selected);
        }
    }

    public static abstract class SystemImageColumnInfo
    extends ColumnInfo<AvdWizardConstants.SystemImageDescription, String> {
        private final Border myBorder;
        private final int myWidth;

        public SystemImageColumnInfo(@NotNull String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageList$SystemImageColumnInfo", "<init>"));
            }
            super(name);
            this.myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
            this.myWidth = width;
        }

        public SystemImageColumnInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageList$SystemImageColumnInfo", "<init>"));
            }
            this(name, -1);
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdWizardConstants.SystemImageDescription o) {
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JBLabel label = new JBLabel((String)value);
                    label.setBorder(SystemImageColumnInfo.this.myBorder);
                    if (table.getSelectedRow() == row) {
                        label.setBackground(table.getSelectionBackground());
                        label.setForeground(table.getSelectionForeground());
                        label.setOpaque(true);
                    }
                    return label;
                }
            };
        }

        @Nullable
        public Comparator<AvdWizardConstants.SystemImageDescription> getComparator() {
            return new Comparator<AvdWizardConstants.SystemImageDescription>(){

                @Override
                public int compare(AvdWizardConstants.SystemImageDescription o1, AvdWizardConstants.SystemImageDescription o2) {
                    String s1 = (String)SystemImageColumnInfo.this.valueOf(o1);
                    String s2 = (String)SystemImageColumnInfo.this.valueOf(o2);
                    return Comparing.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
            };
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }

    public static interface SystemImageSelectionListener {
        public void onSystemImageSelected(@Nullable AvdWizardConstants.SystemImageDescription var1);
    }
}

